<?php 
//echo '<pre>';print_r($GLOBALS);echo '</pre>';exit;

//if(isset($_POST['edit_estimated_hour']))
//{
//    echo '<pre>';print_r($_POST);echo '</pre>';exit; 
//}


# MantisBT - a php based bugtracking system

# MantisBT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# MantisBT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.

	/**
	 * This include file prints out the bug information
	 * $f_bug_id MUST be specified before the file is included
	 *
	 * @package MantisBT
	 * @copyright Copyright (C) 2000 - 2002  Kenzaburo Ito - kenito@300baud.org
	 * @copyright Copyright (C) 2002 - 2011  MantisBT Team - mantisbt-dev@lists.sourceforge.net
	 * @link http://www.mantisbt.org
	 */

	if ( !defined( 'BUG_VIEW_INC_ALLOW' ) ) {
		access_denied();
	}

	 /**
	  * MantisBT Core API's
	  */
	require_once( 'core.php' );

	require_once( 'bug_api.php' );
	require_once( 'custom_field_api.php' );
	require_once( 'file_api.php' );
	require_once( 'date_api.php' );
	require_once( 'relationship_api.php' );
	require_once( 'last_visited_api.php' );
	require_once( 'tag_api.php' );
	require_once( 'projax_api.php' );

        //echo '<pre>';print_r($GLOBALS);echo '</pre>';exit;
	$f_bug_id = gpc_get_int( 'id' );
        
	bug_ensure_exists( $f_bug_id );
        
        if ($_POST['action'] == 'addcomment') {
            //echo $_POST['hour'];exit;
            require_once( 'bugnote_api.php' );
            
            $f_private = 0;
            $f_time_tracking = gpc_get_string('time_tracking', '0:00');
            $f_bugnote_text = trim(gpc_get_string('description', ''));

            
            $t_bug = bug_get($f_bug_id, true);
            if ($t_bug->project_id != helper_get_current_project()) {
                # in case the current project is not the same project of the bug we are viewing...
                # ... override the current project. This to avoid problems with categories and handlers lists etc.
                $g_project_override = $t_bug->project_id;
            }

            if (bug_is_readonly($f_bug_id)) {
                error_parameters($f_bug_id);
                trigger_error(ERROR_BUG_READ_ONLY_ACTION_DENIED, ERROR);
            }

            access_ensure_bug_level(config_get('add_bugnote_threshold'), $f_bug_id);

            // We always set the note time to BUGNOTE, and the API will overwrite it with TIME_TRACKING
            // if $f_time_tracking is not 0 and the time tracking feature is enabled.
            // changes by Nitin for task 266 on [24-2-2012]
            $user_id = $_POST['reporter_id'];
            $t_bugnote_id = bugnote_add($f_bug_id, $f_bugnote_text, $f_time_tracking, $f_private, BUGNOTE, '', $user_id);

            
            # Handle the file upload
            //changed by Tahir Khan for multiple file upload on 25july2012
            if ($t_bugnote_id){
                $f_file = gpc_get_file('file', null);
                $file = array();
                for($i = 1;$i<= count($f_file['name']);$i++){

                    $file['name'] =  $f_file['name'][$i-1];
                    $file['type'] =  $f_file['type'][$i-1];
                    $file['tmp_name'] =  $f_file['tmp_name'][$i-1];
                    $file['error'] =  $f_file['error'][$i-1];
                    $file['size'] =  $f_file['size'][$i-1];
                    if ( !is_blank( $file['tmp_name'] ) && ( 0 < $file['size'] ) ) {
                            file_add( $f_bug_id, $file, 'bug', '', '', null, $t_bugnote_id );
                    }
                }
            }
            # Handle custom field submission
            //eof Tahir Khan

            // change to insert date and time 
            $comment_date   = gpc_get_string('date'); 
            $date = explode("/",$comment_date);
            $current_min = gpc_get_int('current_min');
            $current_hour = gpc_get_int('current_hour');
            
            $date_stamp = mktime($current_hour,$current_min,0,$date[0],$date[1],$date[2]);//Tahir Khan 9aug2012 to store date as a timestamp
            if(empty($_POST['hour']))$_POST['hour'] = '0';
            if(empty($_POST['minute']))$_POST['minute'] = '0';
            $comment_time = $_POST['hour'] . "." . $_POST['minute'];
            //if ($comment_date != '') { //condition removed by Tahir Khan 25july2012.bcoz if date was empty,work duration was also being empty.
            if($_POST['hour'] < 16) 
                bugnote_add_date_time($t_bugnote_id, $date_stamp, $comment_time);
            //}
            if (!$t_bugnote_id) {
                error_parameters(lang_get('bugnote'));
                trigger_error(ERROR_EMPTY_FIELD, ERROR);
            }


            header("Location: ".$_SERVER[REQUEST_URI].""); //modified by Tahir khan 26july2012.
            //html_meta_redirect('view.php?id=' . $f_bug_id);
            
            //$query = "INSERT INTO mantis_bug_comment_table ( reporter_id, bug_id, text ) VALUES ( " . db_param() . ',' . db_param() . ',' . db_param() . ')';
            //db_query_bound($query, Array($c_reporter_id, $f_bug_id, $c_description));
        }
        
        
        // code to edit estimated hour form submission handling Tahir Khan 12july 2012
        
       if ($_POST['edit_estimated_hour'] == 'Submit') {
           $new_estimate = gpc_get_int('new_estimate',0);//$_POST['new_estimate'];
           $old_estimate = $t_bug->estimated_hour;//$_POST['old_estimate'];
           if(empty($new_estimate) && $new_estimate < 1)
               $new_estimate = 1;
           $comment = $_POST['hourcommment'];
           $f_time_tracking = '';
           $f_private = 0;
           require_once( 'bugnote_api.php' );
           $t_bug = bug_get($f_bug_id, true);
            if ($t_bug->project_id != helper_get_current_project()) {
                # in case the current project is not the same project of the bug we are viewing...
                # ... override the current project. This to avoid problems with categories and handlers lists etc.
                $g_project_override = $t_bug->project_id;
            }

            if (bug_is_readonly($f_bug_id)) {
                error_parameters($f_bug_id);
                trigger_error(ERROR_BUG_READ_ONLY_ACTION_DENIED, ERROR);
            }

            access_ensure_bug_level(config_get('add_bugnote_threshold'), $f_bug_id);
           //$user_id = $_POST['reporter_id'];
           $user_id  = auth_get_current_user_id();
           $f_bugnote_text = '';
           $f_bugnote_text .= '=== Updated Estimated Time . ==='.'<br/>';
           $f_bugnote_text .= '----------------------------'.'<br/><br/>';
           $f_bugnote_text .= 'Previos Estimated Hour : '.$old_estimate.'<br/>';
           $f_bugnote_text .= '----------------------------'.'<br/><br/>';
           $f_bugnote_text .= 'Updated Estimated Hour : '.$new_estimate.'<br/>';
           $f_bugnote_text .= '----------------------------'.'<br/><br/>';
           $f_bugnote_text .= 'Comment : '.$comment.'<br/>';
           
           $t_bugnote_id = bugnote_add($f_bug_id, $f_bugnote_text, $f_time_tracking, $f_private, BUGNOTE,'',$user_id);
           
           
           
           
           if (!$t_bugnote_id) {
                error_parameters(lang_get('bugnote'));
                trigger_error(ERROR_EMPTY_FIELD, ERROR);
            }
            
           //update new estimated hour
           $f_bug_id = db_prepare_int( $f_bug_id );
           $t_bug_table = db_get_table( 'mantis_bug_table' );

           $query = "UPDATE $t_bug_table
					SET estimated_hour=" . db_param() . "
					WHERE id=" . db_param();
           db_query_bound( $query, Array( $new_estimate, $f_bug_id ) );
            header("Location: ".$_SERVER[REQUEST_URI]."");
            //html_meta_redirect( 'view.php?id='.$f_bug_id );
            
       }
        
        //eof tahir
        
        
        
	$tpl_bug = bug_get( $f_bug_id, true );

	# In case the current project is not the same project of the bug we are
	# viewing, override the current project. This ensures all config_get and other
	# per-project function calls use the project ID of this bug.
	$g_project_override = $tpl_bug->project_id;

	access_ensure_bug_level( VIEWER, $f_bug_id );

	$f_history = gpc_get_bool( 'history', config_get( 'history_default_visible' ) );

	$t_fields = config_get( $tpl_fields_config_option );
	$t_fields = columns_filter_disabled( $t_fields );

	compress_enable();

	if ( $tpl_show_page_header ) {
		html_page_top( bug_format_summary( $f_bug_id, SUMMARY_CAPTION ) );
		print_recently_visited();
	}

	$t_action_button_position = config_get( 'action_button_position' );

	$t_bugslist = gpc_get_cookie( config_get( 'bug_list_cookie' ), false );

	$tpl_show_versions = version_should_show_product_version( $tpl_bug->project_id );
	$tpl_show_product_version = $tpl_show_versions && in_array( 'product_version', $t_fields );
	$tpl_show_fixed_in_version = $tpl_show_versions && in_array( 'fixed_in_version', $t_fields );
	$tpl_show_product_build = $tpl_show_versions && in_array( 'product_build', $t_fields )
		&& ( config_get( 'enable_product_build' ) == ON );
	$tpl_product_build = $tpl_show_product_build ? string_display_line( $tpl_bug->build ) : '';
	$tpl_show_target_version = $tpl_show_versions && in_array( 'target_version', $t_fields )
		&& access_has_bug_level( config_get( 'roadmap_view_threshold' ), $f_bug_id );

	$tpl_product_version_string  = '';
	$tpl_target_version_string   = '';
	$tpl_fixed_in_version_string = '';

	if ( $tpl_show_product_version || $tpl_show_fixed_in_version || $tpl_show_target_version ) {
		$t_version_rows = version_get_all_rows( $tpl_bug->project_id );

		if ( $tpl_show_product_version ) {
			$tpl_product_version_string  = prepare_version_string( $tpl_bug->project_id, version_get_id( $tpl_bug->version, $tpl_bug->project_id ), $t_version_rows );
		}

		if ( $tpl_show_target_version ) {
			$tpl_target_version_string   = prepare_version_string( $tpl_bug->project_id, version_get_id( $tpl_bug->target_version, $tpl_bug->project_id) , $t_version_rows );
		}

		if ( $tpl_show_fixed_in_version ) {
			$tpl_fixed_in_version_string = prepare_version_string( $tpl_bug->project_id, version_get_id( $tpl_bug->fixed_in_version, $tpl_bug->project_id ), $t_version_rows );
		}
	}

	$tpl_product_version_string = string_display_line( $tpl_product_version_string );
	$tpl_target_version_string = string_display_line( $tpl_target_version_string );
	$tpl_fixed_in_version_string = string_display_line( $tpl_fixed_in_version_string );

	$tpl_bug_id = $f_bug_id;
	$tpl_form_title = lang_get( 'bug_view_title' );
	$tpl_wiki_link = config_get_global( 'wiki_enable' ) == ON ? 'wiki.php?id=' . $f_bug_id : '';

	if ( access_has_bug_level( config_get( 'view_history_threshold' ), $f_bug_id ) ) {
		$tpl_history_link = "view.php?id=$f_bug_id&history=1#history";
	} else {
		$tpl_history_link = '';
	}

	$tpl_show_reminder_link = !current_user_is_anonymous() && !bug_is_readonly( $f_bug_id ) &&
		  access_has_bug_level( config_get( 'bug_reminder_threshold' ), $f_bug_id );
	$tpl_bug_reminder_link = 'bug_reminder_page.php?bug_id=' . $f_bug_id;

	$tpl_print_link = 'print_bug_page.php?bug_id=' . $f_bug_id;

	$tpl_top_buttons_enabled = !$tpl_force_readonly && ( $t_action_button_position == POSITION_TOP || $t_action_button_position == POSITION_BOTH );
	$tpl_bottom_buttons_enabled = !$tpl_force_readonly && ( $t_action_button_position == POSITION_BOTTOM || $t_action_button_position == POSITION_BOTH );

	$tpl_show_project = in_array( 'project', $t_fields );
	$tpl_project_name = $tpl_show_project ? string_display_line( project_get_name( $tpl_bug->project_id ) ): '';
	$tpl_show_id = in_array( 'id', $t_fields );
	$tpl_formatted_bug_id = $tpl_show_id ? string_display_line( bug_format_id( $f_bug_id ) ) : '';

	$tpl_show_date_submitted = in_array( 'date_submitted', $t_fields );
	$tpl_date_submitted = $tpl_show_date_submitted ? date( config_get( 'normal_date_format' ), $tpl_bug->date_submitted ) : '';

	$tpl_show_last_updated = in_array( 'last_updated', $t_fields );
	$tpl_last_updated = $tpl_show_last_updated ? date( config_get( 'normal_date_format' ), $tpl_bug->last_updated ) : '';

	$tpl_show_tags = in_array( 'tags', $t_fields ) && access_has_global_level( config_get( 'tag_view_threshold' ) );

	$tpl_bug_overdue = bug_is_overdue( $f_bug_id );

	$tpl_show_view_state = in_array( 'view_state', $t_fields );
	$tpl_bug_view_state_enum = $tpl_show_view_state ? string_display_line( get_enum_element( 'view_state', $tpl_bug->view_state ) ) : '';

	$tpl_show_due_date = in_array( 'due_date', $t_fields ) && access_has_bug_level( config_get( 'due_date_view_threshold' ), $f_bug_id );

	if ( $tpl_show_due_date ) {
		if ( !date_is_null( $tpl_bug->due_date ) ) {
			$tpl_bug_due_date = date( config_get( 'normal_date_format' ), $tpl_bug->due_date );
		} else {
			$tpl_bug_due_date = '';
		}
	}

	$tpl_show_reporter = in_array( 'reporter', $t_fields );
	$tpl_show_handler = in_array( 'handler', $t_fields ) && access_has_bug_level( config_get( 'view_handler_threshold' ), $f_bug_id );
	$tpl_show_additional_information = !is_blank( $tpl_bug->additional_information ) && in_array( 'additional_info', $t_fields );
	$tpl_show_steps_to_reproduce = !is_blank( $tpl_bug->steps_to_reproduce ) && in_array( 'steps_to_reproduce', $t_fields );
	$tpl_show_monitor_box = !$tpl_force_readonly;
	$tpl_show_relationships_box = !$tpl_force_readonly;
	$tpl_show_upload_form = !$tpl_force_readonly && !bug_is_readonly( $f_bug_id );
	$tpl_show_history = $f_history;
	$tpl_show_profiles = config_get( 'enable_profiles' );
	$tpl_show_platform = $tpl_show_profiles && in_array( 'platform', $t_fields );
	$tpl_platform = $tpl_show_platform ? string_display_line( $tpl_bug->platform ) : '';
	$tpl_show_os = $tpl_show_profiles && in_array( 'os', $t_fields );
	$tpl_os = $tpl_show_os ? string_display_line( $tpl_bug->os ) : '';
	$tpl_show_os_version = $tpl_show_profiles && in_array( 'os_version', $t_fields );
	$tpl_os_version = $tpl_show_os_version ? string_display_line( $tpl_bug->os_build ) : '';
	$tpl_show_projection = in_array( 'projection', $t_fields );
	$tpl_projection = $tpl_show_projection ? string_display_line( get_enum_element( 'projection', $tpl_bug->projection ) ) : '';
	$tpl_show_eta = in_array( 'eta', $t_fields );
	$tpl_eta = $tpl_show_eta ? string_display_line( get_enum_element( 'eta', $tpl_bug->eta ) ) : '';
	$tpl_show_attachments = in_array( 'attachments', $t_fields );
	$tpl_can_attach_tag = $tpl_show_tags && !$tpl_force_readonly && access_has_bug_level( config_get( 'tag_attach_threshold' ), $f_bug_id );
	$tpl_show_category = in_array( 'category_id', $t_fields );
	$tpl_category = $tpl_show_category ? string_display_line( category_full_name( $tpl_bug->category_id, false ) ) : '';
	$tpl_show_priority = in_array( 'priority', $t_fields );
	$tpl_priority = $tpl_show_priority ? string_display_line( get_enum_element( 'priority', $tpl_bug->priority ) ) : '';
	$tpl_show_severity = in_array( 'severity', $t_fields );
	$tpl_severity = $tpl_show_severity ? string_display_line( get_enum_element( 'severity', $tpl_bug->severity ) ) : '';
	$tpl_show_reproducibility = in_array( 'reproducibility', $t_fields );
	$tpl_reproducibility = $tpl_show_reproducibility ? string_display_line( get_enum_element( 'reproducibility', $tpl_bug->reproducibility ) ): '';
	$tpl_show_status = in_array( 'status', $t_fields );
	$tpl_status = $tpl_show_status ? string_display_line( get_enum_element( 'status', $tpl_bug->status ) ) : '';
	$tpl_show_resolution = in_array( 'resolution', $t_fields );
	$tpl_resolution = $tpl_show_resolution ? string_display_line( get_enum_element( 'resolution', $tpl_bug->resolution ) ) : '';
	$tpl_show_summary = in_array( 'summary', $t_fields );
	$tpl_show_description = in_array( 'description', $t_fields );

	$tpl_summary = $tpl_show_summary ? bug_format_summary( $f_bug_id, SUMMARY_FIELD ) : '';
	$tpl_description = $tpl_show_description ? $tpl_bug->description : '';
	$tpl_steps_to_reproduce = $tpl_show_steps_to_reproduce ? string_display_links( $tpl_bug->steps_to_reproduce ) : '';
	$tpl_additional_information = $tpl_show_additional_information ? string_display_links( $tpl_bug->additional_information ) : '';

	$tpl_links = event_signal( 'EVENT_MENU_ISSUE', $f_bug_id );
        
        
        
        /*
	#
	# Start of Template
	#

	echo '<br />';
	echo '<table class="width100" cellspacing="1">';
	echo '<tr>';

	# Form Title
	echo '<td class="form-title" colspan="', $t_bugslist ? '3' : '4', '">';

	echo $tpl_form_title;

	echo '&#160;<span class="small">';

	# Jump to Bugnotes
	print_bracket_link( "#bugnotes", lang_get( 'jump_to_bugnotes' ) );

	# Send Bug Reminder
	if ( $tpl_show_reminder_link ) {
		print_bracket_link( $tpl_bug_reminder_link, lang_get( 'bug_reminder' ) );
	}

	if ( !is_blank( $tpl_wiki_link ) ) {
		print_bracket_link( $tpl_wiki_link, lang_get( 'wiki' ) );
	}

	foreach ( $tpl_links as $t_plugin => $t_hooks ) {
		foreach( $t_hooks as $t_hook ) {
			if ( is_array( $t_hook ) ) {
				foreach( $t_hook as $t_label => $t_href ) {
					if ( is_numeric( $t_label ) ) {
						print_bracket_link_prepared( $t_href );
					} else {
						print_bracket_link( $t_href, $t_label );
					}
				}
			} else {
				print_bracket_link_prepared( $t_hook );
			}
		}
	}

	echo '</span></td>';

	# prev/next links
	if ( $t_bugslist ) {
		echo '<td class="center"><span class="small">';

		$t_bugslist = explode( ',', $t_bugslist );
		$t_index = array_search( $f_bug_id, $t_bugslist );
		if ( false !== $t_index ) {
			if ( isset( $t_bugslist[$t_index-1] ) ) {
				print_bracket_link( 'view.php?id='.$t_bugslist[$t_index-1], '&lt;&lt;' );
			}

			if ( isset( $t_bugslist[$t_index+1] ) ) {
				print_bracket_link( 'view.php?id='.$t_bugslist[$t_index+1], '&gt;&gt;' );
			}
		}
		echo '</span></td>';
	}


	# Links
	echo '<td class="right" colspan="2">';

	if ( !is_blank( $tpl_history_link ) ) {
		# History
		echo '<span class="small">';
		print_bracket_link( $tpl_history_link, lang_get( 'bug_history' ) );
		echo '</span>';
	}

	# Print Bug
	echo '<span class="small">';
	print_bracket_link( $tpl_print_link, lang_get( 'print' ) );
	echo '</span>';
	echo '</td>';
	echo '</tr>';

	if ( $tpl_top_buttons_enabled ) {
		echo '<tr align="center">';
		echo '<td align="center" colspan="6">';
		html_buttons_view_bug_page( $tpl_bug_id );
		echo '</td>';
		echo '</tr>';
	}

	if ( $tpl_show_id || $tpl_show_project || $tpl_show_category || $tpl_show_view_state || $tpl_show_date_submitted || $tpl_show_last_updated ) {
		# Labels
		echo '<tr>';
		echo '<td class="category" width="15%">', $tpl_show_id ? lang_get( 'id' ) : '', '</td>';
		echo '<td class="category" width="20%">', $tpl_show_project ? lang_get( 'email_project' ) : '', '</td>';
		echo '<td class="category" width="15%">', $tpl_show_category ? lang_get( 'category' ) : '', '</td>';
		echo '<td class="category" width="15%">', $tpl_show_view_state ? lang_get( 'view_status' ) : '', '</td>';
		echo '<td class="category" width="15%">', $tpl_show_date_submitted ? lang_get( 'date_submitted' ) : '', '</td>';
		echo '<td class="category" width="20%">', $tpl_show_last_updated ? lang_get( 'last_update' ) : '','</td>';
		echo '</tr>';

		echo '<tr ', helper_alternate_class(), '>';

		# Bug ID
		echo '<td>', $tpl_formatted_bug_id, '</td>';

		# Project
		echo '<td>', $tpl_project_name, '</td>';

		# Category
		echo '<td>', $tpl_category, '</td>';

		# View Status
		echo '<td>', $tpl_bug_view_state_enum, '</td>';

		# Date Submitted
		echo '<td>', $tpl_date_submitted, '</td>';

		# Date Updated
		echo '<td>', $tpl_last_updated, '</td>';

		echo '</tr>';

		# spacer
		echo '<tr class="spacer"><td colspan="6"></td></tr>';
	}

	#
	# Reporter
	#

	if ( $tpl_show_reporter ) {
		echo '<tr ', helper_alternate_class(), '>';

		$t_spacer = 4;

		# Reporter
		if ( $tpl_show_reporter ) {
			echo '<td class="category">', lang_get( 'reporter' ), '</td>';
			echo '<td>';
			print_user_with_subject( $tpl_bug->reporter_id, $tpl_bug_id );
			echo '</td>';
		} else {
			$t_spacer += 2;
		}

		echo '<td colspan="', $t_spacer, '">&#160;</td>';

		echo '</tr>';
	}

	#
	# Handler, Due Date
	#

	if ( $tpl_show_handler || $tpl_show_due_date ) {
		echo '<tr ', helper_alternate_class(), '>';

		$t_spacer = 2;

		# Handler
		if ( $tpl_show_handler ) {
			echo '<td class="category">', lang_get( 'assigned_to' ), '</td>';
			echo '<td>';
			print_user_with_subject( $tpl_bug->handler_id, $tpl_bug_id );
			echo '</td>';
		} else {
			$t_spacer += 2;
		}

		# Due Date
		if ( $tpl_show_due_date ) {
			echo '<td class="category">', lang_get( 'due_date' ), '</td>';

			if ( $tpl_bug_overdue ) {
				echo '<td class="overdue">', $tpl_bug_due_date, '</td>';
			} else {
				echo '<td>', $tpl_bug_due_date, '</td>';
			}
		} else {
			$t_spacer += 2;
		}

		echo '<td colspan="', $t_spacer, '">&#160;</td>';
		echo '</tr>';
	}

	#
	# Priority, Severity, Reproducibility
	#

	if ( $tpl_show_priority || $tpl_show_severity || $tpl_show_reproducibility ) {
		echo '<tr ', helper_alternate_class(), '>';

		$t_spacer = 0;

		# Priority
		if ( $tpl_show_priority ) {
			echo '<td class="category">', lang_get( 'priority' ), '</td>';
			echo '<td>', $tpl_priority, '</td>';
		} else {
			$t_spacer += 2;
		}

		# Severity
		if ( $tpl_show_severity ) {
			echo '<td class="category">', lang_get( 'severity' ), '</td>';
			echo '<td>', $tpl_severity, '</td>';
		} else {
			$t_spacer += 2;
		}

		# Reproducibility
		if ( $tpl_show_reproducibility ) {
			echo '<td class="category">', lang_get( 'reproducibility' ), '</td>';
			echo '<td>', $tpl_reproducibility, '</td>';
		} else {
			$t_spacer += 2;
		}

		# spacer
		if ( $t_spacer > 0 ) {
			echo '<td colspan="', $t_spacer, '">&#160;</td>';
		}

		echo '</tr>';
	}

	#
	# Status, Resolution
	#

	if ( $tpl_show_status || $tpl_show_resolution ) {
		echo '<tr ', helper_alternate_class(), '>';

		$t_spacer = 2;

		# Status
		if ( $tpl_show_status ) {
			echo '<td class="category">', lang_get( 'status' ), '</td>';
			echo '<td bgcolor="', get_status_color( $tpl_bug->status ), '">', $tpl_status, '</td>';
		} else {
			$t_spacer += 2;
		}

		# Resolution
		if ( $tpl_show_resolution ) {
			echo '<td class="category">', lang_get( 'resolution' ), '</td>';
			echo '<td>', $tpl_resolution, '</td>';
		} else {
			$t_spacer += 2;
		}

		# spacer
		if ( $t_spacer > 0 ) {
			echo '<td colspan="', $t_spacer, '">&#160;</td>';
		}

		echo '</tr>';
	}

	#
	# Projection, ETA
	#

	if ( $tpl_show_projection || $tpl_show_eta ) {
		echo '<tr ', helper_alternate_class(), '>';

		$t_spacer = 2;

		if ( $tpl_show_projection ) {
			# Projection
			echo '<td class="category">', lang_get( 'projection' ), '</td>';
			echo '<td>', $tpl_projection, '</td>';
		} else {
			$t_spacer += 2;
		}

		# ETA
		if ( $tpl_show_eta ) {
			echo '<td class="category">', lang_get( 'eta' ), '</td>';
			echo '<td>', $tpl_eta, '</td>';
		} else {
			$t_spacer += 2;
		}

		echo '<td colspan="', $t_spacer, '">&#160;</td>';
		echo '</tr>';
	}

	#
	# Platform, OS, OS Version
	#

	if ( $tpl_show_platform || $tpl_show_os || $tpl_show_os_version ) {
		$t_spacer = 0;

		echo '<tr ', helper_alternate_class(), '>';

		# Platform
		if ( $tpl_show_platform ) {
			echo '<td class="category">', lang_get( 'platform' ), '</td>';
			echo '<td>', $tpl_platform, '</td>';
		} else {
			$t_spacer += 2;
		}

		# Operating System
		if ( $tpl_show_os ) {
			echo '<td class="category">', lang_get( 'os' ), '</td>';
			echo '<td>', $tpl_os, '</td>';
		} else {
			$t_spacer += 2;
		}

		# OS Version
		if ( $tpl_show_os_version ) {
			echo '<td class="category">', lang_get( 'os_version' ), '</td>';
			echo '<td>', $tpl_os_version, '</td>';
		} else {
			$t_spacer += 2;
		}

		if ( $t_spacer > 0 ) {
			echo '<td colspan="', $t_spacer, '">&#160;</td>';
		}

		echo '</tr>';
	}

	#
	# Product Version, Product Build
	#

	if ( $tpl_show_product_version || $tpl_show_product_build ) {
		$t_spacer = 2;

		echo '<tr ', helper_alternate_class(), '>';

		# Product Version
		if ( $tpl_show_product_version ) {
			echo '<td class="category">', lang_get( 'product_version' ), '</td>';
			echo '<td>', $tpl_product_version_string, '</td>';
		} else {
			$t_spacer += 2;
		}

		# Product Build
		if ( $tpl_show_product_build ) {
			echo '<td class="category">', lang_get( 'product_build' ), '</td>';
			echo '<td>', $tpl_product_build, '</td>';
		} else {
			$t_spacer += 2;
		}

		# spacer
		echo '<td colspan="', $t_spacer, '">&#160;</td>';

		echo '</tr>';
	}

	#
	# Target Version, Fixed In Version
	#

	if ( $tpl_show_target_version || $tpl_show_fixed_in_version ) {
		$t_spacer = 2;

		echo '<tr ', helper_alternate_class(), '>';

		# target version
		if ( $tpl_show_target_version ) {
			# Target Version
			echo '<td class="category">', lang_get( 'target_version' ), '</td>';
			echo '<td>', $tpl_target_version_string, '</td>';
		} else {
			$t_spacer += 2;
		}

		# fixed in version
		if ( $tpl_show_fixed_in_version ) {
			echo '<td class="category">', lang_get( 'fixed_in_version' ), '</td>';
			echo '<td>', $tpl_fixed_in_version_string, '</td>';
		} else {
			$t_spacer += 2;
		}

		# spacer
		echo '<td colspan="', $t_spacer, '">&#160;</td>';

		echo '</tr>';
	}

	#
	# Bug Details Event Signal
	#

	event_signal( 'EVENT_VIEW_BUG_DETAILS', array( $tpl_bug_id ) );

	# spacer
	echo '<tr class="spacer"><td colspan="6"></td></tr>';

	#
	# Bug Details (screen wide fields)
	#

	# Summary
	if ( $tpl_show_summary ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'summary' ), '</td>';
		echo '<td colspan="5">', $tpl_summary, '</td>';
		echo '</tr>';
	}

	# Description
	if ( $tpl_show_description ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'description' ), '</td>';
		echo '<td colspan="5">', $tpl_description, '</td>';
		echo '</tr>';
	}

	# Steps to Reproduce
	if ( $tpl_show_steps_to_reproduce ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'steps_to_reproduce' ), '</td>';
		echo '<td colspan="5">', $tpl_steps_to_reproduce, '</td>';
		echo '</tr>';
	}

	# Additional Information
	if ( $tpl_show_additional_information ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'additional_information' ), '</td>';
		echo '<td colspan="5">', $tpl_additional_information, '</td>';
		echo '</tr>';
	}

	# Tagging
	if ( $tpl_show_tags ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'tags' ), '</td>';
		echo '<td colspan="5">';
		tag_display_attached( $tpl_bug_id );
		echo '</td></tr>';
	}

	# Attachments Form
	if ( $tpl_can_attach_tag ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', lang_get( 'tag_attach_long' ), '</td>';
		echo '<td colspan="5">';
		print_tag_attach_form( $tpl_bug_id );
		echo '</td></tr>';
	}

	# spacer
	echo '<tr class="spacer"><td colspan="6"></td></tr>';

	# Custom Fields
	$t_custom_fields_found = false;
	$t_related_custom_field_ids = custom_field_get_linked_ids( $tpl_bug->project_id );

	foreach( $t_related_custom_field_ids as $t_id ) {
		if ( !custom_field_has_read_access( $t_id, $f_bug_id ) ) {
			continue;
		} # has read access

		$t_custom_fields_found = true;
		$t_def = custom_field_get_definition( $t_id );

		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category">', string_display( lang_get_defaulted( $t_def['name'] ) ), '</td>';
		echo '<td colspan="5">';
		print_custom_field_value( $t_def, $t_id, $f_bug_id );
		echo '</td></tr>';
	}

	if ( $t_custom_fields_found ) {
		# spacer
		echo '<tr class="spacer"><td colspan="6"></td></tr>';
	} # custom fields found

	# Attachments
	if ( $tpl_show_attachments ) {
		echo '<tr ', helper_alternate_class(), '>';
		echo '<td class="category"><a name="attachments" id="attachments" />', lang_get( 'attached_files' ), '</td>';
		echo '<td colspan="5">';
		print_bug_attachments_list( $tpl_bug_id );
		echo '</td></tr>';
	}

	if ( $tpl_bottom_buttons_enabled ) {
		echo '<tr align="center"><td align="center" colspan="6">';
		html_buttons_view_bug_page( $tpl_bug_id );
		echo '</td></tr>';
	}

	echo '</table>';

	# User list sponsoring the bug
	include( $tpl_mantis_dir . 'bug_sponsorship_list_view_inc.php' );

	# Bug Relationships
	if ( $tpl_show_relationships_box ) {
		relationship_view_box ( $tpl_bug->id );
	}

	# File upload box
	if ( $tpl_show_upload_form ) {
		include( $tpl_mantis_dir . 'bug_file_upload_inc.php' );
	}

	# User list monitoring the bug
	if ( $tpl_show_monitor_box ) {
		include( $tpl_mantis_dir . 'bug_monitor_list_view_inc.php' );
	}

	# Bugnotes and "Add Note" box
	if ( 'ASC' == current_user_get_pref( 'bugnote_order' ) ) {
		include( $tpl_mantis_dir . 'bugnote_view_inc.php' );

		if ( !$tpl_force_readonly ) {
			include( $tpl_mantis_dir . 'bugnote_add_inc.php' );
		}
	} else {
		if ( !$tpl_force_readonly ) {
			include( $tpl_mantis_dir . 'bugnote_add_inc.php' );
		}

		include( $tpl_mantis_dir . 'bugnote_view_inc.php' );
	}

	# Allow plugins to display stuff after notes
	event_signal( 'EVENT_VIEW_BUG_EXTRA', array( $f_bug_id ) );

	# Time tracking statistics
	if ( config_get( 'time_tracking_enabled' ) &&
		access_has_bug_level( config_get( 'time_tracking_view_threshold' ), $f_bug_id ) ) {
		include( $tpl_mantis_dir . 'bugnote_stats_inc.php' );
	}
        // */

?>
<link rel="stylesheet" type="text/css" href="css/tcal.css" />
<!--<script type="text/javascript" src="js/tcal.js"></script> -->
<script type="text/javascript" src="js/jquery-1.7.1.min.js"></script>
<link rel="stylesheet" type="text/css" href="css/jquery-ui-1.7.3.custom.css" />
                    
<script type="text/javascript" src="js/jquery-ui-1.7.3.custom.min.js"></script>
<link rel="stylesheet" href="css/colorbox.css" />
<script src="js/jquery.colorbox-min.js"></script>
<style>
	body{font:12px/1.2 Verdana, sans-serif; padding:0 10px;}
	a:link, a:visited{text-decoration:none; color:#416CE5; border-bottom:1px solid #416CE5;}
	h2{font-size:13px; margin:15px 0 0 0;}
</style>

<script type="text/javascript"> 
    jQuery(function() {
        jQuery.datepicker.setDefaults({
            showButtonPanel: true
        });
       
       jQuery( "#start_date" ).datepicker({
            dateFormat: 'yy-mm-dd',
            duration: 'fast',
            beforeShow: function() {
                
                jQuery('#colorbox, #cboxOverlay, #cboxWrapper').css('z-index', '0');
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery("#start_date").attr('Disabled', false); 
                jQuery('#colorbox, #cboxOverlay, #cboxWrapper').css('z-index', '9999');
            }
        });
        
        jQuery( "#end_date" ).datepicker({
            dateFormat: 'yy-mm-dd',
            duration: 'fast',
            beforeShow: function() {
                
                jQuery('#colorbox, #cboxOverlay, #cboxWrapper').css('z-index', '0');
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery("#end_date").attr('Disabled', false); 
                jQuery('#colorbox, #cboxOverlay, #cboxWrapper').css('z-index', '9999');
            }
        });
    });
    
    

</script>

<?php
	# History
	if ( $tpl_show_history ) {
	//	 include( $tpl_mantis_dir . 'history_inc.php' );
	}
        
        ?>
<div style="padding-top: 0px;" align="center"><?php print_succ_err_msg();?></div>
<div class="bugviewWidth" id="bugviewContainer">
    <?php
    # History
    if ( $tpl_show_history ) {
             include( $tpl_mantis_dir . 'history_inc_custom.php' );
    }
    ?>
    <div id="bugviewActionButtonsTop" class="buttonbar buttonbarTop">
        <ul class="toolbar nextprev">
            <?php
            # MONITOR/UNMONITOR button
            if( !current_user_is_anonymous() ) {
                    echo '<td class=center">';
                    if( user_is_monitoring_bug( auth_get_current_user_id(), $tpl_bug_id ) ) {
                            html_button_bug_unmonitor( $tpl_bug_id );
                    } else {
                            html_button_bug_monitor( $tpl_bug_id );
                    }
                    echo '</td>';
            }
            ?>
        </ul>
        <ul class="toolbar buttons">
            <?php html_button_bug_delete($tpl_bug_id); ?>
            <?php 
            if( !$t_readonly ) {
                html_button_bug_update( $tpl_bug_id );
                html_button_bug_assign_to( $tpl_bug_id );
            }

            if ( !$t_readonly || config_get( 'allow_reporter_close' ) ) {
                html_button_bug_change_status( $tpl_bug_id );
            }
            ?>
        </ul>
    </div>


    <div id="bugviewContainerTop" class="top droplistsFillParent">
        <div class="ixBug">
            <div class="ixBug1">
                <?php echo $tpl_formatted_bug_id; ?> <br />
                <?php echo $tpl_category; ?>
                <?php 
                echo "<div style='font-size:12px; padding-top:10px'>";
                $t_related_custom_field_ids = custom_field_get_ids();
				$i = 0;
                foreach ($t_related_custom_field_ids as $t_id) {
                    
                    if($i == 0) {
                        if (!custom_field_has_read_access($t_id, $f_bug_id)) {
                            continue;
                        } # has read access

                        $t_custom_fields_found = true;
                        $t_def = custom_field_get_definition($t_id);
                        if ($i == 0) {
                            $t_custom_field_value = custom_field_get_value($t_id, $f_bug_id);
                            if (($t_custom_field_value - 86400) >= time()) {
                                echo '<span style="color:green; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            } else {
                                echo '<span style="color:red; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            }
                        } else {
                            echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                            print_custom_field_value($t_def, $t_id, $f_bug_id);
                        }
                    }
                    $i++;
// BOF changes done by Nitin for task 266 to show the Start Date of the task	
					$t_def = custom_field_get_definition($t_id);
					if ($t_def['name'] == 'Start Date') {
							$t_custom_field_value = custom_field_get_value($t_id, $f_bug_id);
                            if (($t_custom_field_value - 86400) >= time()) {
                                echo '<span style="color:green; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            } else {
                                echo '<span style="color:red; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            }
                        } 
// BOF changes done by Nitin for task 266 to show the Start Date of the task	
                }
                echo "</div>";
                ?>
                
            </div>
        </div>

        <div class="bugFields">
            <div class="idTitleProjectAndArea">
                <div class="content title"><?php echo $tpl_bug->summary; ?></div>

                <div class="content statusbar">
                    <span class="categoryAndAssignedTo"> Assigned to: <?php echo print_user_with_subject($tpl_bug->handler_id, $tpl_bug_id); ?> </span>
                    <span class="status active"><?php echo $tpl_resolution; ?></span>
                </div>
            </div>
            
            <div class="fixAlignment">&nbsp;</div>
        
       
        </div>

        <div class="fixAlignment">&nbsp;</div>
         <?php
        if ( $tpl_show_relationships_box ) {
		echo relationship_get_summary_html ( $tpl_bug->id );
	}
        
       ?>
        
    </div>
	
    <div class="fixAlignment">&nbsp;</div>

    <div id="bugviewContainerSide" class="side droplistsFillParent">
        <div id="sidebar_priority_-1">
            <label style="font-size: 18px" title="Cases are usually fixed in order of priority.">Priority: <?php echo $tpl_priority; ?></label>
        </div>
        <div id="sidebar_priority_-1">
            <label style="font-size: 18px" title="Cases are usually fixed in order of priority.">Severity: <?php echo $tpl_severity; ?></label>
        </div>
        
        <div id="sidebar_tags_-1">
            <?php
            if ( $tpl_show_tags ) { ?>
                <br />
                <label title="tags">Tags: <?php tag_display_attached( $tpl_bug_id ); ?></label>
            <?php } ?>
            <?php if ( $tpl_can_attach_tag ) { ?>
                <div class="clear" style="clear: both; padding-top: 20px"> </div>
                <label style="padding-top: 10px">Attach Tags:</label>
                <div>
                    <?php lang_get( 'tag_attach_long' ); ?>
                    <?php print_tag_attach_form( $tpl_bug_id ); ?>
                </div>
            <?php } ?>
                
            <?php    
            //if ( $tpl_show_upload_form ) {
		//include( $tpl_mantis_dir . 'bug_file_upload_inc.php' );
            //}
            ?>
           
		   <?php  
// BOF changes done by Nitin for task 266 to show the Start Date of the task [27-2-2012]
			 $i = 0;
			 echo '<div class="clear" style="clear: both; padding-top: 20px"> </div>';
			 echo '<div>';
                foreach ($t_related_custom_field_ids as $t_id) {
                    
                    if($i == 0) {
                        if (!custom_field_has_read_access($t_id, $f_bug_id)) {
                            continue;
                        } # has read access

                        $t_custom_fields_found = true;
                        $t_def = custom_field_get_definition($t_id);
                        if ($i == 0) {
                            $t_custom_field_value = custom_field_get_value($t_id, $f_bug_id);
                            if (($t_custom_field_value - 86400) >= time()) {
                                echo '<span style="color:green; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            } else {
                                echo '<span style="color:red; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            }
                        } else {
                            echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                            print_custom_field_value($t_def, $t_id, $f_bug_id);
                        }
                    }
                    $i++;
	
					$t_def = custom_field_get_definition($t_id);
					if ($t_def['name'] == 'Start Date') {
							$t_custom_field_value = custom_field_get_value($t_id, $f_bug_id);
                            if (($t_custom_field_value - 86400) >= time()) {
                                echo '<span style="color:green; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            } else {
                                echo '<span style="color:red; font-size:11px">';
                                echo '<b>', string_display(lang_get_defaulted($t_def['name'])), ': </b>';
                                print_custom_field_value($t_def, $t_id, $f_bug_id);
                                echo '</span> <br/>';
                            }
                        } 
                } 
			echo '</div>'; 
			echo '<div><a class="inline" onclick="color_box(\'inline\')" href="#inline_content">edit</a></div>'; 
// EOF changes done by Nitin for task 266 to show the Start Date of the task [27-2-2012]
			
                        ?>
        </div>
<!--        bof to show and edit estimated hours by Tahir Khan on 12-07-2012-->
            
<div id="show_estimation" >
    <p style="font-weight: bold;">Estimated Hour : <a href="#edit_hours" onclick="<?php echo 'color_box(\'edit_hour\')'; ?> " class="edit_hour" ><?php echo (empty($tpl_bug->estimated_hour)?'00':$tpl_bug->estimated_hour);?></a></p>
</div>
<!--eof tahir-->

<!-- bof to show parent child relation by Tahir Khan on 17-07-2012-->
<?php    
    define("INCLUE_PARENT_CHILED_RELATION_FILE", True);
    include( $tpl_mantis_dir . 'mantis_include_parent_child_case.php' );
?>            
<!--eof tahir-->


    </div>
	
        <div class="bugevents">
            <div class="droplistsFillParent" id="bugviewContainerEdit"></div>
            <span id="BugEvents">
                <div class="bugevent detailed" id="bugevent">
                    <div id="bugeventEditLink<?php echo $tpl_bug_id; ?>" style="float: right"><a href="javascript://" onclick="editContent('<?php echo $tpl_bug_id ?>', '1')">Edit</a></div>
                    <div class="summary" id="bugeventSummary">
                        <span class="action">Reported by <?php print_user_with_subject($tpl_bug->reporter_id, $tpl_bug_id); ?></span>&nbsp;
                        <span dir="ltr" class="date"><?php echo date("M d, Y h:i a", strtotime($tpl_date_submitted . ":00")); ?></span>
                    </div>
                    <div dir="ltr" class="changes" id="bugeventChanges"></div>
                    
                    <span style="display: none" id="CaseEventEditInsertionPoint<?php echo $tpl_bug_id; ?>">
                        
                    </span>
                    <div class="body" id="bugeventBody<?php echo $tpl_bug_id; ?>">
                        <div id="bugcontent<?php echo $tpl_bug_id; ?>"><?php echo $tpl_description; ?></div>
                        <?php
                        $t_attachments = file_get_visible_attachments( $tpl_bug_id );
                        $t_attachments_count = count( $t_attachments );
                        if($t_attachments_count > 0) { 
                        ?>
                        <strong>Attached Files</strong>  <br /><br />
                        <?php print_bug_attachments_list( $tpl_bug_id ); ?>
                        <?php } ?>
                    </div>
                    <div class="attachments" id="bugeventBody">
                        <div id="containerAttachmentList"> </div>
                    </div>
                    <div id="extraaction<?php echo $tpl_bug_id; ?>"> </div>
                    
                </div>
                
                
                <?php
                
                include( $tpl_mantis_dir . 'bugnote_view_modified_inc.php' );

                /*
                $query = "SELECT * FROM mantis_bug_comment_table WHERE bug_id =" . db_param();
                $result = db_query_bound( $query, Array( $tpl_bug_id ) );
                if($result) {
                    foreach($result as $comment) {
                        ?>
                        <div class="bugevent detailed" id="bugevent">
                        <div class="summary" id="bugeventSummary">
                        <span class="action">Reported by <?php print_user_with_subject($comment['reporter_id'], $tpl_bug_id); ?></span>&nbsp;
                        <span dir="ltr" class="date"><?php echo date("M d, Y h:i a", strtotime($comment['created_date'])); ?></span>
                        </div>
                        <div dir="ltr" class="changes" id="bugeventChanges"></div>
                        <span id="CaseEventEditInsertionPoint7"></span>
                        <div class="body" id="bugeventBody">
                            <?php echo str_replace("\n", "<br />", $comment['text']) ?>
                        </div>
                        <div class="attachments" id="bugeventBody">
                        <div id="containerAttachmentList"> </div>
                        </div>
                                </div>

                        <?php
                    }
                }
                 * 
                 */
                ?>
                <form action="view.php?id=<?php echo $f_bug_id; ?>" method="post" enctype="multipart/form-data">
                    <div class="body editable">
                        <div class="editor wideTextareaWrapper">
                            <div class="editModeSelector addcomment">
                                Add Your Comment
								<!-- changes by Nitin Sharma [24-2-2012] -->
								As
								 <select name="reporter_id">
								<?php	print_reporter_option_list( auth_get_current_user_id(), $t_bug->project_id ) ?>
								</select>
                            </div>
							<!-- bof changes by Nitin for task 266 on [24-2-2012] -->
						    <div class="editModeSelector addcomment">
							<span class="action">
								Date: <input type="text" name="date" class="tcal" value="" readonly="readonly" size="8" id="inputdate" /> 
								Duration: <select name="hour">
									<?php
										for($i=0;$i <= 15 ;$i++){
											echo "<option value=$i>$i</option>";
										}
									?>
									</select> hours
									<select name="minute">
									<option value="00">00</option>
                                                                        <option value="25">15</option>
                                                                        <option value="50">30</option>
                                                                        <option value="75">45</option>
									</select> minutes
							</span>
							</div>
                                                        
							<!-- eof changes by Nitin for task 266 on [24-2-2012] -->
                            <?php
                                echo '<textarea ', helper_get_tab_index(), ' cols="80" rows="10" id="elm2" name="description">', $tpl_description_textarea, '</textarea>';
                            ?>
                                <script type="text/javascript">
                                    $.noConflict();
                                </script>
                                <script type="text/javascript" src="javascript/ckeditor/ckeditor.js"></script>
                                <script type="text/javascript" src="javascript/ckeditor/custom.js"></script>
                        </div>
                        
                        <div style="margin-top: 10px;width:115px;float:left;" class="footer" id="submitButtonsEdit">
                            
                            <input style="width:112px;float:right;margin:0px;padding:0px;" <?php echo helper_get_tab_index() ?> type="submit" class="button" value="Submit Comment" onclick="return checkdate();" />
                            
                            <input type="hidden" name="action" value="addcomment" />
                        </div>
                        <!-- bof to include upload file option .Tahir Khan 25july-2012-->
                            <?php    
                            if ( $tpl_show_upload_form ) {
                                define("INCLUE_MULTIPLE_FILE", True);
                                include( $tpl_mantis_dir . 'mantis_bugnote_file_upload.php' );
                            }
                            
                            ?>
                        
                        <!-- eof tahir  -->
			
                        
<!--                    funtion to check if date is not selected.Tahir Khan 25july 2012-->
                        <script type="text/javascript">
                        function checkdate(){
                            if(document.getElementById("inputdate").value == ''){
                                alert("Please Select Date!");
                                document.getElementById("inputdate").style.backgroundColor = "#FD6564";
                                return false;
                            }else return true;
                        }
                        </script>
<!--                        eof Tahir-->
                        

                    </div>
<!--                    to send current time and minutes.Tahir Khan 9aug2012-->
                    <input type="hidden" id="current_hour" name="current_hour" value="" />
                    <input type="hidden" id="current_min" name="current_min" value="" />
                    <script>
                            var d = new Date();
                            var c_hour = d.getHours();
                            var c_min = d.getMinutes();
                            
                            document.getElementById("current_hour").value = c_hour;
                            document.getElementById("current_min").value = c_min;
                    </script>
<!--                        eof Tahir-->
                </form>
                
                
                
            </span>
        </div>
	<div class="fixAlignment">&nbsp;</div>
        <div id="bugviewActionButtonsBottom" class="buttonbar buttonbarBottom">
            <ul class="toolbar nextprev">

            </ul>
            <ul class="toolbar buttons">
                <?php html_button_bug_delete($tpl_bug_id); ?>
                <?php 
                if( !$t_readonly ) {
                    html_button_bug_update( $tpl_bug_id );
                    html_button_bug_assign_to( $tpl_bug_id );
                }

                if ( !$t_readonly || config_get( 'allow_reporter_close' ) ) {
                    html_button_bug_change_status( $tpl_bug_id );
                }
                ?>
            </ul>
            <div class="sizerRight ui-draggable"> </div>
        </div>
		
		<div style='display:none'>
                    	<div id='inline_content' style='padding:10px; background:#fff;'>
				<form name="change_date" method="post" id="change_date" action="bug_change_date.php">
				<?php
					$i = 0;
					foreach ($t_related_custom_field_ids as $t_id) {
                    	$t_def = custom_field_get_definition($t_id);
						if($i == 0) {
							if (!custom_field_has_read_access($t_id, $f_bug_id)) {
								continue;
							} # has read access
	
							
							if ($i == 0) {
								$end_date = string_custom_field_value($t_def, $t_id, $f_bug_id);
								
							} else {
								$end_date = string_custom_field_value($t_def, $t_id, $f_bug_id);
							}
						}
						$i++;
						if ($t_def['name'] == 'Start Date') {
							$start_date = string_custom_field_value($t_def, $t_id, $f_bug_id);
                        } 
					}
					if(empty($end_date)){ 
						$end_date = array( date("Y"),date("m"),date("d"));
					}
					else{
						$end_date = explode("-",$end_date); 
					}
					
					if(empty($start_date)) {
						$start_date = array( date("Y"),date("m"),date("d"));
					}
					else{
						$start_date = explode("-",$start_date);
					}
					
				?>
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td><b>Start Date :</b></td>
							<td>
                                                            <input type="text" name="start_date" class="" value="<?php echo $start_date[0].'-'.$start_date[1].'-'.$start_date[2];?>" size="8" id="start_date" />
							</td>
						</tr>
						
						<tr>
							<td><b>End Date :</b></td>
							<td>
                                                            <input type="text" name="end_date" class="" value="<?php echo $end_date[0].'-'.$end_date[1].'-'.$end_date[2];?>"  size="8" id="end_date" />
							</td>
						</tr>
						
						<tr>
							<td><b>Comments :</b></td>
							<td><textarea name="comment" rows="4" cols="50" id="comment"></textarea></td>
						</tr>
						
						<tr>
							<td><input type="hidden" name="bug_id" value="<?php echo $f_bug_id ?>" /></td>
							<td><input type="submit" name="submit_change_date" value="Submit"/></td>
						</tr>
					</table>
				</form>
			</div>
                    
<!--                    bof to edit estimated hour Tahir Khan 12july 2012 -->
                        <div id='edit_hours' style='padding:10px; background:#fff;'>
                            <form name="edit_estimated_hours" method="post" id="change_date" action="">
                                <div style="float:left;margin-right: 35px;">
                                    <p style="font-weight: bold;margin: 2px 0px 0px 0px !important;">Old Estimated Hour : <a href="#" class="" ><?php echo $tpl_bug->estimated_hour;?></a></p>
                                </div>
                                <div style="float: left">
                                    <p style="float: left;font-weight: bold;margin: 2px 0px 0px 0px !important;">New Estimated Hour :</p><input value="" id="houredit" onkeyup="//return only_float(this.value,this.id);" type="text" size="8" maxlength="4" name="new_estimate" />
                                </div> 
                                
                                <div style="float: left;margin-top: 10px;margin-bottom: 10px;">
                                    <p style="float: left;font-weight: bold;margin: 2px 0px 0px 0px !important;">Comment :</p><textarea style="margin-left: 5px;" rows="5" cols="40" name="hourcommment"></textarea>
                                </div> 
                                <br/>
<!--                                <input type="hidden" name="reporter_id" value="<?php echo auth_get_current_user_id();?>"/>-->
                                
                                
                                <input  type="hidden" name="old_estimate" value="<?php echo $tpl_bug->estimated_hour;?>" />

                                <input style="float:left;clear: both;" type="submit" value="Submit" name="edit_estimated_hour" />
                            </form>
                        </div>

<!--eof tahir-->
                    
		</div>
		
		
</div>
<script type="text/javascript">
    var editor = '';
    function editContent(id, type) { 
        new Ajax.Request('ajax_update.php', {
          method: 'post',
          parameters: {bugid: id, type: type, action : 'get'},
          onSuccess: function(transport){
          var response = transport.responseText;
          $("bugeventBody" + id).style.display = "none";
          $("bugeventEditLink" + id).style.display = "none";
          $("extraaction" + id).style.display = "none";
          $("CaseEventEditInsertionPoint" + id).style.display = "block";
          $("CaseEventEditInsertionPoint" + id).innerHTML = response;
          areaid = 'editArea' + id;
          editor = CKEDITOR.replace( areaid,
            {
                skin : 'kama',
                toolbar : 'MyToolbar',
                filebrowserBrowseUrl: "kfms/"
            });
        }
        });
    }
    
    function updateContent(id, type) {
        var value = editor.getData();
        
        var date_val = document.getElementById('edit_inputdate_' + id ).value;
        var hour_val = document.getElementById('edit_hour_' + id ).value;
        var mint_val = document.getElementById('edit_minute_' + id ).value;
        var t_time = hour_val+"."+mint_val;
        var d = new Date();
        var c_hour = d.getHours();
        var c_min = d.getMinutes();
        //c_hour = c_hour - 12;
       // c_hour = Math.abs(c_hour);

        var current_hour = c_hour;
        var current_min = c_min;
        
        var reporter = document.getElementById("edit_reporter_id"+id);
        var reporter_id = reporter.options[reporter.selectedIndex].value;
        
        new Ajax.Request('ajax_update.php', {
          method: 'post',
          parameters: {bugid: id, type: type, content : value,date : date_val,current_hour : c_hour, current_min : c_min,time : t_time,reporter_id:reporter_id, action: 'update'},
          onSuccess: function(transport){
//          var response = transport.responseText;
//          $("bugcontent" + id).innerHTML = response;
//          $("bugeventBody" + id).style.display = "block";
//          $("bugeventEditLink" + id).style.display = "block";
//          $("CaseEventEditInsertionPoint" + id).style.display = "none";
//          $("extraaction" + id).style.display = "";
          submit_ajax_form(id);
          //window.location.reload();
          
        }
        
        })
         
    }
    
    function updateContent_bug(id, type){  //function call can be seen in editing bug.
        var value = editor.getData();
        
        new Ajax.Request('ajax_update.php', {
          method: 'post',
          parameters: {bugid: id, type: type, content : value, action: 'update'},
          onSuccess: function(transport){
//          var response = transport.responseText;
//          $("bugcontent" + id).innerHTML = response;
//          $("bugeventBody" + id).style.display = "block";
//          $("bugeventEditLink" + id).style.display = "block";
//          $("CaseEventEditInsertionPoint" + id).style.display = "none";
//          $("extraaction" + id).style.display = "";
            submit_ajax_form(id);
        }
        
        })
    }
    
    function submit_ajax_form(id){
        document.forms["ajax_file_"+id].submit();
    }
    
    function cancelEditContent(id){
//        $("bugcontent" + id).innerHTML = 'hi there';
//        $("bugeventBody" + id).style.display = "block";
//        $("bugeventEditLink" + id).style.display = "block";
//        $("CaseEventEditInsertionPoint" + id).innerHTML = '';
//        $("CaseEventEditInsertionPoint" + id).style.display = "none";
//        $("extraaction" + id).style.display = "";
//        areaid = 'editArea' + id;
//          editor = CKEDITOR.replace( areaid,
//            {
//                skin : 'kama',
//                toolbar : 'MyToolbar',
//                filebrowserBrowseUrl: "kfms/"
//            });
        window.location.reload();
    }
	
    jQuery("#change_date").submit(function(){
            if(jQuery("#comment").val() == ""){
                    alert("Please Enter Comment");
                    return false;
            }
    });
                  
               
        
</script>


<script type="text/javascript">
   //TAHIR ,to edit estimated hour 12july 2012
        jQuery.noConflict();

        function color_box(clas){
            jQuery("."+clas).colorbox({inline:true, width:"50%"});
        }
        
       
        function only_float(value,id){
            value = value.replace(/[^0-9]/g,"");
            document.getElementById(id).value = value;
        }
        //eof    
    
    
</script>

<script> 
    jQuery(function() {
        jQuery( "#inputdate" ).datepicker({
            dateFormat: 'mm/dd/yy',
            maxDate: new Date,
            duration: 'fast',
            beforeShow: function() {
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery("#inputdate").attr('Disabled', false); 
                
            }
        });
        
        jQuery( "#start_date" ).datepicker({
            dateFormat: 'mm/dd/yy',
            maxDate: new Date,
            duration: 'fast',
            beforeShow: function() {
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery("#start_date").attr('Disabled', false); 
                
            }
        });
        
        jQuery( "#end_date" ).datepicker({
            dateFormat: 'mm/dd/yy',
            maxDate: new Date,
            duration: 'fast',
            beforeShow: function() {
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery("#end_date").attr('Disabled', false); 
                
            }
        });
    });
</script>

<script type="text/javascript">
    function edit_inputdate(id){ // function to select date while editing bugnote.Tahir khan 10aug2012
        jQuery( "#edit_inputdate_"+ id ).blur();
      jQuery( "#edit_inputdate_"+ id ).datepicker({
            dateFormat: 'mm/dd/yy',
            maxDate: new Date,
            duration: 'fast',
            beforeShow: function() {
                var id= "#" + this.id;
                jQuery(id).attr('Disabled', true); 
                
            },
            
            onClose: function(dateText) { 
                
                jQuery( "#edit_inputdate_"+ id ).attr('Disabled', false); 
                
            }
        });
    }  
    
</script>


<?php
        
	html_page_bottom();

	last_visited_issue( $tpl_bug_id );
