<?php
# MantisBT - a php based bugtracking system
# MantisBT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# MantisBT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This include file prints out the list of bugnotes attached to the bug
 * $f_bug_id must be set and be set to the bug id
 *
 * @package MantisBT
 * @copyright Copyright (C) 2000 - 2002  Kenzaburo Ito - kenito@300baud.org
 * @copyright Copyright (C) 2002 - 2011  MantisBT Team - mantisbt-dev@lists.sourceforge.net
 * @link http://www.mantisbt.org
 */
/**
 * Requires bugnote API
 */
require_once( 'current_user_api.php' );


# grab the user id currently logged in
$t_user_id = auth_get_current_user_id();

#precache access levels
if (isset($g_project_override)) {
    access_cache_matrix_project($g_project_override);
} else {
    access_cache_matrix_project(helper_get_current_project());
}

# get the bugnote data
$t_bugnote_order = current_user_get_pref('bugnote_order');
$t_bugnotes = bugnote_get_all_visible_bugnotes($f_bug_id, $t_bugnote_order, 0, $t_user_id);

#precache users
$t_bugnote_users = array();
foreach ($t_bugnotes as $t_bugnote) {
    $t_bugnote_users[] = $t_bugnote->reporter_id;
}
user_cache_array_rows($t_bugnote_users);

$num_notes = count($t_bugnotes);
?>

<?php # Bugnotes BEGIN  ?>

<?php
# no bugnotes
if (0 == $num_notes) {
    ?>

    <?php
}

event_signal('EVENT_VIEW_BUGNOTES_START', array($f_bug_id, $t_bugnotes));

$t_normal_date_format = config_get('normal_date_format');
$t_total_time = 0;

for ($i = 0; $i < $num_notes; $i++) {
    $t_bugnote = $t_bugnotes[$i];

    if ($t_bugnote->date_submitted != $t_bugnote->last_modified)
        $t_bugnote_modified = true;
    else
        $t_bugnote_modified = false;

    $t_bugnote_id_formatted = bugnote_format_id($t_bugnote->id);

    if (0 != $t_bugnote->time_tracking) {
        $t_time_tracking_hhmm = db_minutes_to_hhmm($t_bugnote->time_tracking);
        $t_bugnote->note_type = TIME_TRACKING;   // for older entries that didn't set the type @@@PLR FIXME
        $t_total_time += $t_bugnote->time_tracking;
    } else {
        $t_time_tracking_hhmm = '';
    }

    if (VS_PRIVATE == $t_bugnote->view_state) {
        $t_bugnote_css = 'bugnote-private';
        $t_bugnote_note_css = 'bugnote-note-private';
    } else {
        $t_bugnote_css = 'bugnote-public';
        $t_bugnote_note_css = 'bugnote-note-public';
    }
    ?>
    <a name="c<?php echo $t_bugnote->id; ?>" > </a>
    <div class="bugevent detailed" id="bugevent">
        <div id="bugeventEditLink<?php echo $t_bugnote->id; ?>" style="float: right">
            <?php
            if ($t_can_delete_note || access_has_bug_level(config_get('delete_bugnote_threshold'), $f_bug_id)) {
                //print_button('bugnote_delete.php?bugnote_id=' . $t_bugnote->id, lang_get('delete_link'));
            }
            ?>
            <a href="javascript://" onclick="editContent('<?php echo $t_bugnote->id; ?>', '2')">Edit</a>
        </div>

        <div class="summary" id="bugeventSummary">
            <span class="action">Reported by <?php print_user_with_subject($t_bugnote->reporter_id, $tpl_bug_id); ?></span>&nbsp;
            <span dir="ltr" class="date"><?php echo date("M d, Y h:i a", $t_bugnote->date_submitted); ?></span>
            
            <!-- BOF changes made by Nitin to show the time done on task [6-3-2012]	-->
            <span ><b>Work Duration : </b></span><?php echo (empty($t_bugnote->comment_time)) ?  '0.0' : $t_bugnote->comment_time;//echo $t_bugnote->comment_time; ?>

            <!-- EOF changes made by Nitin to show the time done on task [6-3-2012]	-->
            <!--            to show if past comment is done using past dates.Tahir khan 9aug2012-->
            </br><?php print_comment_date_on_need($t_bugnote->id,$t_bugnote->date_submitted);?>
            <!--            eof tahir-->

        </div>
        <div dir="ltr" class="changes" id="bugeventChanges"></div>

        <span  style="display: none" id="CaseEventEditInsertionPoint<?php echo $t_bugnote->id; ?>"></span>

        <div class="body" id="bugeventBody<?php echo $t_bugnote->id; ?>">
            <div id="bugcontent<?php echo $t_bugnote->id; ?>">
                <?php echo $t_bugnote->note; ?>
            </div>
            <!--            bof to show attachments (if any) with this bugnote. Tahir Khan 25july 2012-->
            <?php
            $t_max_file_size = (int) min(ini_get_number('upload_max_filesize'), ini_get_number('post_max_size'), config_get('max_file_size'));
            $t_attachments = file_get_visible_attachments($tpl_bug_id, $t_bugnote->id);
            $t_attachments_count = count($t_attachments);
            if ($t_attachments_count > 0) {
                ?>
                <strong>Attached Files</strong>  <br /><br />
                <?php print_bug_attachments_list($tpl_bug_id, $t_bugnote->id); ?>
            <?php } ?>
            <!--                        eof Tahir-->
        </div>
        <div class="attachments" id="bugeventBody">
            <div id="containerAttachmentList"> </div>
        </div>

        <div class="small" id="extraaction<?php echo $t_bugnote->id; ?>" style="padding: 4px 0px">
            <?php
            # bug must be open to be editable
            if (!bug_is_readonly($f_bug_id)) {
                $t_can_edit_note = false;
                $t_can_delete_note = false;

                # admins and the bugnote creator can edit/delete this bugnote
                if (( access_has_bug_level(config_get('manage_project_threshold'), $f_bug_id) ) ||
                        ( ( $t_bugnote->reporter_id == $t_user_id ) && ( ON == config_get('bugnote_allow_user_edit_delete') ) )) {
                    $t_can_edit_note = true;
                    $t_can_delete_note = true;
                }

                # users above update_bugnote_threshold should be able to edit this bugnote
                if ($t_can_edit_note || access_has_bug_level(config_get('update_bugnote_threshold'), $f_bug_id)) {
                    // print_button('bugnote_edit_page.php?bugnote_id=' . $t_bugnote->id, lang_get('bugnote_edit_link'));
                }

                # users above delete_bugnote_threshold should be able to delete this bugnote
                if ($t_can_delete_note || access_has_bug_level(config_get('delete_bugnote_threshold'), $f_bug_id)) {
                    echo " ";
                    print_button('bugnote_delete.php?bugnote_id=' . $t_bugnote->id, lang_get('delete_link'));
                }

                # users with access to both update and change view status (or the bugnote author) can change public/private status
                if ($t_can_edit_note || ( access_has_bug_level(config_get('update_bugnote_threshold'), $f_bug_id) &&
                        access_has_bug_level(config_get('change_view_status_threshold'), $f_bug_id) )) {
                    if (VS_PRIVATE == $t_bugnote->view_state) {
                        echo " ";
                        //print_button('bugnote_set_view_state.php?private=0&bugnote_id=' . $t_bugnote->id, lang_get('make_public'));
                    } else {
                        echo " ";
                        //print_button('bugnote_set_view_state.php?private=1&bugnote_id=' . $t_bugnote->id, lang_get('make_private'));
                    }
                }
            }
            ?>
        </div>

    </div>
    


    <?php
}

event_signal('EVENT_VIEW_BUGNOTES_END', $f_bug_id);
?>
<script type="text/javascript">
                    
    function ajax_file(bugnote_id){
        var id = bugnote_id;
        var temp = jQuery('#count_'+id).val();
        temp = parseInt(temp) + 1;
                        
        var increase_hyt = jQuery('#file_count_'+id).val();
        increase_hyt = parseInt(increase_hyt) + 25;
        jQuery('#file_setting_'+id).attr("style","height:"+increase_hyt+"px");
        jQuery('#file_count_'+id).val(increase_hyt);
        jQuery('#count_'+id).val(temp);
        jQuery('#sFileEdit_'+ id).append('<div id="main_filecontainer_'+id+'_' + temp + '"><div style="float:left;" id="file_container_'+id+'_'+temp + '" ><?php echo lang_get('upload_file') ?><?php echo '<span class="small" style="margin-right: 1px" >(' . lang_get('max_file_size') . ': ' . number_format($t_max_file_size / 1000) . 'k)</span>'; ?><input  name="file_'+id+'[]" type="file" size="40" /></div><div style="float:left;margin-left:5px;margin-top:2px;" ><input onclick="edit_remove_file('+id+','+temp+')" type="button" title="" style="float:left;background-image: url(images/remove.jpg);height: 20px;width: 20px;" /></div><div style="clear:both;"></div></div>');
        //jQuery('#file_setting_'+id).val(temp);
    }
                    
    function edit_remove_file(id,temp){
        jQuery('#main_filecontainer_'+id+'_'+temp).remove();
                        
        var decrease_hyt = jQuery('#file_count_'+id).val();
        decrease_hyt = parseInt(decrease_hyt) - 25;
        jQuery('#file_setting_'+id).attr("style","height:"+decrease_hyt+"px");
        jQuery('#file_count_'+id).val(decrease_hyt);
                        
    }
                    
</script>

