<?php
# page to download timesheet data. Tahir Khan 3august2012
require_once( 'core.php' );

/** PHPExcel */
require_once 'PHPExcel.php';

/** PHPExcel_IOFactory */
require_once 'PHPExcel/IOFactory.php';


date_default_timezone_set('UTC');

auth_ensure_user_authenticated();
$t_hour = gpc_get_int('t_hour', '0');
$t_minute = gpc_get_int('t_minute', '0');
$s_date = date_in_dd_mm_yy(gpc_get_string('start_date', ''));
$e_date = date_in_dd_mm_yy(gpc_get_string('end_date', ''),$t_hour , $t_minute);
$project_list = gpc_get_string_array('projectlist');
$user_list = gpc_get_string_array('userlist');
//echo '<pre>';print_r($user_list);echo '</pre>';exit;

$user_list = implode(',',$user_list);
$project_list = implode(',',$project_list);


$query = "SELECT mbnt.comment_date, mbnt.comment_time, mbntt.note, mbt.summary ,mpt.name, mut.realname
                        FROM mantis_bugnote_table mbnt left join mantis_user_table mut on(mbnt.reporter_id = mut.id) ,
                        mantis_bugnote_text_table mbntt,
                        mantis_bug_table mbt left join mantis_project_table mpt on(mbt.project_id = mpt.id)
                        WHERE mbnt.comment_date >= '" . $s_date . "' && mbnt.comment_date <= '" . $e_date . "' &&
                              mbnt.bugnote_text_id =  mbntt.id &&
                              mbnt.bug_id          = mbt.id &&
                              
                              mbnt.reporter_id IN (" . $user_list . ") &&
                              mbt.project_id IN (" . $project_list . ")"." order by comment_date "; 


$result =  db_query($query);
$t_count = db_num_rows( $result );
if($t_count == 0){
    echo "<h1>No Record Found.</h1>";
    exit;
}

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

$objPHPExcel->getProperties()->setCreator("Tahir Khan")
							 ->setLastModifiedBy("Tahir Khan")
							 ->setTitle("Office 2007 TimeSheet Report")
							 ->setSubject("TimeSheet Report")
							 ->setDescription("TimeSheet Report")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("TimeSheet Report");


// Add some data

$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Report');
$objPHPExcel->getActiveSheet()->setCellValue('F1', PHPExcel_Shared_Date::PHPToExcel( gmmktime(date('m'),date('d'),date('Y')) ));

$objPHPExcel->getActiveSheet()->getStyle('F1')->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_XLSX15);

$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->setName('Candara');
$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->setSize(20);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_WHITE);

$objPHPExcel->getActiveSheet()->getStyle('E1')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_WHITE);
$objPHPExcel->getActiveSheet()->getStyle('F1')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_WHITE);

$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFill()->getStartColor()->setARGB('FF808080');

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(60);


$objPHPExcel->getActiveSheet()->setCellValue('A3', 'DATE');
$objPHPExcel->getActiveSheet()->setCellValue('B3', 'PROJECT');
$objPHPExcel->getActiveSheet()->setCellValue('C3', 'TASK');
$objPHPExcel->getActiveSheet()->setCellValue('D3', 'USER');
$objPHPExcel->getActiveSheet()->setCellValue('E3', 'TIME');
$objPHPExcel->getActiveSheet()->setCellValue('F3', 'COMMENT');

$objPHPExcel->getActiveSheet()->getStyle('A3:F3')->applyFromArray(
		array(
			'font'    => array(
				'bold'      => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
			),
			'borders' => array(
				'top'     => array(
 					'style' => PHPExcel_Style_Border::BORDER_THIN
 				)
			),
			'fill' => array(
	 			'type'       => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
	  			'rotation'   => 90,
	 			'startcolor' => array(
	 				'argb' => 'FFA0A0A0'
	 			),
	 			'endcolor'   => array(
	 				'argb' => 'FFFFFFFF'
	 			)
	 		)
		)
);

$i=5;
$total_time=0;
for($ii = 0; $ii < $t_count; $ii++) {

    $nt1 = db_fetch_array( $result );
    if($nt1['comment_time'] == '0.0' || empty($nt1['comment_time']))continue; //just exclude excelsheet rows for zero time
    
    $objPHPExcel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    $objPHPExcel->getActiveSheet()->setCellValue('A'.$i, date("M d, Y",$nt1['comment_date']));

    $objPHPExcel->getActiveSheet()->getStyle('B'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $objPHPExcel->getActiveSheet()->getStyle('B'.$i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    $objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $nt1['name']);

    $objPHPExcel->getActiveSheet()->getStyle('C'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $objPHPExcel->getActiveSheet()->getStyle('C'.$i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle('C'.$i)->getAlignment()->setWrapText(true);
    $objPHPExcel->getActiveSheet()->setCellValue('C'.$i, $nt1['summary']);

    $objPHPExcel->getActiveSheet()->getStyle('D'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $objPHPExcel->getActiveSheet()->getStyle('D'.$i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    $objPHPExcel->getActiveSheet()->setCellValue('D'.$i, $nt1['realname']);

    $objPHPExcel->getActiveSheet()->getStyle('E'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $objPHPExcel->getActiveSheet()->getStyle('E'.$i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    
    $total_time = $total_time + (float)$nt1['comment_time'];
    $objPHPExcel->getActiveSheet()->setCellValue('E'.$i, $nt1['comment_time']);
	
    $objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_JUSTIFY);
    $objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getAlignment()->setWrapText(true);
    
    $note = strip_tags($nt1['note']);
    $note = str_replace("&nbsp;","",$note);
    $note = " ".$note." ";
    $objPHPExcel->getActiveSheet()->setCellValue('F'.$i, $note);

    $i++;
    
}

$objPHPExcel->getActiveSheet()->getStyle('D'.$i.':E'.$i)->applyFromArray(
		array(
			'font'    => array(
				'bold'      => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
			),
			'borders' => array(
				'top'     => array(
 					'style' => PHPExcel_Style_Border::BORDER_THIN
 				)
			),
			'fill' => array(
	 			'type'       => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
	  			'rotation'   => 90,
	 			'startcolor' => array(
	 				'argb' => 'FFA0A0A0'
	 			),
	 			'endcolor'   => array(
	 				'argb' => 'FFFFFFFF'
	 			)
	 		)
		)
);
$objPHPExcel->getActiveSheet()->setCellValue('D'.$i, "Total Hours:");
$objPHPExcel->getActiveSheet()->setCellValue('E'.$i, $total_time);

//$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddHeader('&C&HPlease treat this document as confidential!');
//$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddFooter('&L&B' . $objPHPExcel->getProperties()->getTitle() . '&RPage &P of &N');

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('TimeSheet Report');

$filename = date('d-M-Y')."-timeSheetReport.xlsx";
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$filename.'"');
header('Cache-Control: max-age=0');
ob_end_clean();
$objWriter->save('php://output');

exit;