/**
 *
 * JQuery fn.gantt gantt chart plugin v1.2.0
 * Copyright 2011 by Marek Bielańczuk
 * http://mbielanczuk.com/
 * Released under the MIT and GPL Licenses.
 *
 * Date: Wed Aug 29 2012 16:00:00 +0100
 */
(function($){
    $.fn.gantt=function(J){
        var K=['hours','days','weeks','months'];
        var L={
            source:null,
            itemsPerPage:7,
            months:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],
            dow:["Su","M","T","W","Thr","F","Sa"],
            startPos:new Date(),
            navigate:'buttons',
            scale:'days',
            maxScale:'months',
            minScale:'hours',
            waitText:'Please wait...'
        };
        
        $.extend($.expr[':'],{
            findday:function(a,i,m){
                var b=new Date(parseInt(m[3]));
                var c=$(a).attr('id');
                c=c?c:'';
                var d=c.indexOf('-')+1;
                var e=new Date(parseInt(c.substring(d,c.length)));
                b=new Date(b.getFullYear(),b.getMonth(),b.getDate());
                e=new Date(e.getFullYear(),e.getMonth(),e.getDate());
                return b.getTime()==e.getTime()
                }
            });
    $.extend($.expr[':'],{
        findweek:function(a,i,m){
            var b=new Date(parseInt(m[3]));
            var c=$(a).attr('id');
            c=c?c:'';
            var d=c.indexOf('-')+1;
            b=b.getFullYear()+'-'+b.getDayForWeek().getWeekOfYear();
            var e=c.substring(d,c.length);
            return b==e
            }
        });
$.extend($.expr[':'],{
    findmonth:function(a,i,m){
        var b=new Date(parseInt(m[3]));
        b=b.getFullYear()+'-'+b.getMonth();
        var c=$(a).attr('id');
        c=c?c:'';
        var d=c.indexOf('-')+1;
        var e=c.substring(d,c.length);
        return b==e
        }
    });
Date.prototype.getDayOfYear=function(){
    var a=new Date(this.getFullYear(),0,0);
    var b=new Date(this.getFullYear(),this.getMonth(),this.getDate());
    return Math.ceil((b-a)/86400000)
    };
    
Date.prototype.getWeekOfYear=function(){
    var a=new Date(this.getFullYear(),0,1);
    var b=new Date(this.getFullYear(),this.getMonth(),this.getDate());
    if(a.getDay()>3)a=new Date(b.getFullYear(),0,7-a.getDay());
    var c=b.getDayOfYear()-a.getDayOfYear();
    return Math.ceil(c/7)
    };
    
Date.prototype.getDaysInMonth=function(){
    return 32-new Date(this.getFullYear(),this.getMonth(),32).getDate()
    };
    
Date.prototype.hasWeek=function(){
    var a=new Date(this.valueOf());
    a.setDate(a.getDate()-a.getDay());
    var b=new Date(this.valueOf());
    b.setDate(b.getDate()+(6-b.getDay()));
    if(a.getMonth()==b.getMonth())return true;
    else{
        return(a.getMonth()==this.getMonth()&&b.getDate()<4)||(a.getMonth()!=this.getMonth()&&b.getDate()>=4)
        }
    };

Date.prototype.getDayForWeek=function(){
    var a=new Date(this.valueOf());
    a.setDate(a.getDate()-a.getDay());
    var b=new Date(this.valueOf());
    b.setDate(b.getDate()+(6-b.getDay()));
    if((a.getMonth()==b.getMonth())||(a.getMonth()!=b.getMonth()&&b.getDate()>=4)){
        return new Date(b.setDate(b.getDate()-3))
        }else{
        return new Date(a.setDate(a.getDate()+3))
        }
    };

var M={
    create:function(b){
        if(typeof(L.source)=='object'){
            b.data=L.source;
            M.init(b)
            }else{
            $.ajaxSetup({
                scriptCharset:"utf-8",
                contentType:"application/json; charset=utf-8"
            });
            $.getJSON(L.source,function(a){
                b.data=a;
                M.init(b)
                })
            }
        },
init:function(a){
    a.rowsNum=a.data.length;
    a.pageCount=Math.ceil(a.rowsNum/L.itemsPerPage);
    a.rowsOnLastPage=a.rowsNum-(Math.floor(a.rowsNum/L.itemsPerPage)*L.itemsPerPage);
    a.dateStart=N.getMinDate(a);
    a.dateEnd=N.getMaxDate(a);
    M.render(a);
    M.waitToggle(a,true,function(){
        M.render(a)
        })
    },
render:function(a){
    var b=$('<div class="fn-content"/>');
    b.append(M.leftPanel(a));
    var c=M.rightPanel(a);
    b.append(c);
    b.append(M.navigation(a));
    $dataPanel=c.find('.dataPanel');
    a.gantt=$('<div class="fn-gantt" />').append(b);
    $(a).html(a.gantt);
    a.scrollNavigation.panelMargin=parseInt($dataPanel.css('margin-left').replace('px',''));
    a.scrollNavigation.panelMaxPos=($dataPanel.width()-c.width());
    a.scrollNavigation.canScroll=($dataPanel.width()>c.width());
    M.markNow(a);
    M.fillData(a);
    $(a).css({
        height:$(a).find(".fn-gantt").height()+"px"
        });
    var d=Math.round((L.startPos/1000-a.dateStart/1000)/86400)-2;
    if(d>0&&a.hPosition!=0){
        if(a.scaleOldWidth){
            var e=($dataPanel.width()-c.width());
            var f=e*a.hPosition/a.scaleOldWidth;
            f=f>0?0:f;
            $dataPanel.css({
                'margin-left':f+'px'
                });
            a.scrollNavigation.panelMargin=f;
            a.hPosition=f;
            a.scaleOldWidth=null
            }else{
            $dataPanel.css({
                'margin-left':a.hPosition+'px'
                });
            a.scrollNavigation.panelMargin=a.hPosition
            }
            M.repositionLabel(a)
        }else{
        M.repositionLabel(a)
        }
        M.waitToggle(a,false)
    },
leftPanel:function(b){
    var c=$('<div class="leftPanel"/>').append($('<div class="row spacer"/>').css("height",N.getCellSize()*b.headerRows+"px").css("width","100%"));
    $.each(b.data,function(i,a){
        if(i>=b.pageNum*L.itemsPerPage&&i<(b.pageNum*L.itemsPerPage+L.itemsPerPage)){
            if(a.desc == 'project')
                c.append($('<div class="row name row'+i+' "/>').append($('<span class="label project_bold"/>').html(a.name))).append($('<div class="row desc row'+i+' "/>').append($('<span class="label"/>').html(a.desc)))
            else
                c.append($('<div onclick="highligh('+i+');" class="row name row'+i+' highlight'+i+'"/>').append($('<span class="label task_padding"/>').html(a.name))).append($('<div class="row desc row'+i+' "/>').append($('<span class="label"/>').html(a.desc)))
        }
        });
return c
},
dataPanel:function(b,c){ //alert(b);
    var d=$('<div class="dataPanel" style="width: '+c+'px;"/>');
    var f=(/Firefox/i.test(navigator.userAgent))?"DOMMouseScroll":"mousewheel";
    if(document.attachEvent)b.attachEvent("on"+f,function(e){
        M.wheelScroll(b,e)
        });
    else if(document.addEventListener)b.addEventListener(f,function(e){
        M.wheelScroll(b,e)
        },false);
    d.mousedown(function(e){
        if(e.which!=1)return true;
        if(e.preventDefault)e.preventDefault();
        b.scrollNavigation.panelMouseDown=true;
        M.mouseScroll(b,e)
        }).mousemove(function(e){
        if(b.scrollNavigation.panelMouseDown){
            M.mouseScroll(b,e)
            }
        });
$(document).mouseup(function(e){
    if(e.which!=1)return true;
    b.scrollNavigation.panelMouseDown=false;
    b.scrollNavigation.mouseX=null;
    var a=$(b).find('.fn-gantt .dataPanel');
    a.css("cursor","auto");
    M.repositionLabel(b)
    });
return d
},
rightPanel:function(a){
    var b=null;
    var c=[' sn',' wd',' wd',' wd',' wd',' wd',' sa'];
    var d=[' sn','','','','','',' sa'];
    var e=$("<div class='row'/>");
    var f=0;
    var g=$("<div class='row'/>");
    var h=0;
    var j='';
    var k=0;
    var l='';
    var m='';
    var n=new Date();
    n=new Date(n.getFullYear(),n.getMonth(),n.getDate());
    var o=L.holidays?L.holidays.join():'';
    switch(L.scale){
        case'hours':
            b=N.parseTimeRange(a.dateStart,a.dateEnd,a.scaleStep);
            var p=b[0].getFullYear();
            var q=b[0].getMonth();
            var r=b[0];
            for(var i=0;i<b.length;i++){
            var s=b[i];
            var t=s.getFullYear();
            if(t!=p){
                e.html(e.html()+$('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>'));
                p=t;
                f=0
                }
                f++;
            var u=s.getMonth();
            if(u!=q){
                g.append($('<div class="row header month" style="width: '+N.getCellSize()*h+'px"><div class="label"/>'+L.months[q]+'</div></div>'));
                q=u;
                h=0
                }
                h++;
            var v=s.getDay();
            var w=r.getDay();
            var y=c[v];
            var z=r.getTime();
            if(o.indexOf((new Date(s.getFullYear(),s.getMonth(),s.getDate())).getTime())>-1)y="holiday";
            if(v!=w){
                var A=(n-r==0)?' today':(o.indexOf(z)>-1)?"hollyday":c[w]; 
                j+='<div class="row day '+A+'" '+' style="width: '+N.getCellSize()*k+'px;"> '+' <div class="label"/>'+r.getDate()+'</div></div>';
                l+='<div class="row day '+A+'" '+' style="width: '+N.getCellSize()*k+'px;"> '+' <div class="label"/>'+L.dow[w]+'</div></div>';
                r=s;
                k=0
                }
                k++;
            m+='<div class="row day '+y+'" id="dh-'+s.getTime()+'"> '+s.getHours()+'</div>'
            }
            e.html(e.html()+'<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label"/>'+p+'</div></div>');
            g.html(g.html()+'<div class="row header month" style="width: '+N.getCellSize()*h+'px"><div class="label"/>'+L.months[q]+'</div></div>');
            var y=c[r.getDay()];
            if(o.indexOf((new Date(r.getFullYear(),r.getMonth(),r.getDate())).getTime())>-1)y="hollyday";
            j+='<div class="row day '+y+'" '+' style="width: '+N.getCellSize()*k+'px;"> '+' <div class="label"/>'+r.getDate()+'</div></div>';
            l+='<div class="row day '+y+'" '+' style="width: '+N.getCellSize()*k+'px;"> '+' <div class="label"/>'+L.dow[r.getDay()]+'</div></div>';
            var B=M.dataPanel(a,b.length*N.getCellSize());
            B.append(e);
            B.append(g);
            B.append($('<div class="row"/>').html(j));
            B.append($('<div class="row"/>').html(l));
            B.append($('<div class="row"/>').html(m));
            for(var i=0;i<a.data.length;i++){
            var C=a.data[i];
            if(i>=a.pageNum*L.itemsPerPage&&i<(a.pageNum*L.itemsPerPage+L.itemsPerPage)){
                var D='<div class="row">';
                for(var x=0;x<b.length;x++){
                    var r=b[x];
                    var E=d[r.getDay()];
                    if(o.indexOf((new Date(r.getFullYear(),r.getMonth(),r.getDate())).getTime())>-1)E=" hollyday";
                    D+='<div class="row day'+E+'" id="d'+i+'-'+N.genId(r.getTime())+'" ></div>'
                    };
                    
                B.html(B.html()+D+'</div>')
                }
            }
        break;
    case'weeks':
        b=N.parseWeeksRange(a.dateStart,a.dateEnd);
        var p=b[0].getFullYear();
        var q=b[0].getMonth();
        var r=b[0];
        for(var i=0;i<b.length;i++){
        var s=b[i];
        if(s.getFullYear()!=p){
            e.append($('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>'));
            p=s.getFullYear();
            f=0
            }
            f++;
        if(s.getMonth()!=q){
            g.append($('<div class="row header month" style="width:'+N.getCellSize()*h+'px;"><div class="label">'+L.months[q]+'</div></div>'));
            q=s.getMonth();
            h=0
            }
            h++;
        j+='<div class="row day wd" '+' id="dh-'+s.getFullYear()+'-'+s.getWeekOfYear()+'"> '+' <div class="label"/>'+s.getWeekOfYear()+'</div></div>'
        }
        e.append('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label"/>'+p+'</div></div>');
        g.append('<div class="row header month" style="width: '+N.getCellSize()*h+'px"><div class="label"/>'+L.months[q]+'</div></div>');
        var B=M.dataPanel(a,b.length*N.getCellSize());
        B.append(e);
        B.append(g);
        B.append($('<div class="row"/>').html(j));
        B.append($('<div class="row"/>').html(l));
        for(var i=0;i<a.data.length;i++){
        var C=a.data[i];
        if(i>=a.pageNum*L.itemsPerPage&&i<(a.pageNum*L.itemsPerPage+L.itemsPerPage)){
            var D='<div class="row">';
            for(var x=0;x<b.length;x++){
                r=b[x];
                D+='<div class="row day" id="d'+i+'-'+N.genId(r.getTime())+'"></div>'
                };
                
            B.append($(D+'</div>'))
            }
        }
    break;
case'months':
    b=N.parseMonthsRange(a.dateStart,a.dateEnd);
    var p=b[0].getFullYear();
    var q=b[0].getMonth();
    var r=b[0];
    for(var i=0;i<b.length;i++){
    var s=b[i];
    if(s.getFullYear()!=p){
        e.append($('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>'));
        p=s.getFullYear();
        f=0
        }
        f++;
    g.append($('<div class="row day wd" id="dh-'+N.genId(s.getTime())+'" />').html(s.getMonth()+1))
    }
    e.append('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>');
    g.append('<div class="row header month" style="width: '+N.getCellSize()*h+'px">"<div class="label">'+L.months[q]+'</div></div>');
    var B=M.dataPanel(a,b.length*N.getCellSize());
    B.append(e);
    B.append(g);
    B.append($('<div class="row"/>').html(j));
    B.append($('<div class="row"/>').html(l));
    for(var i=0;i<a.data.length;i++){
    var C=a.data[i];
    if(i>=a.pageNum*L.itemsPerPage&&i<(a.pageNum*L.itemsPerPage+L.itemsPerPage)){
        var D='<div class="row">';
        for(var x=0;x<b.length;x++){
            r=b[x];
            D+='<div class="row day" id="d'+i+'-'+N.genId(r.getTime())+'" ></div>'
            };
            
        B.append($(D+'</div>'))
        }
    }
break;
default:
    b=N.parseDateRange(a.dateStart,a.dateEnd);
    var p=b[0].getFullYear();
    var q=b[0].getMonth();
    var r=b[0];
    for(var i=0;i<b.length;i++){
    var s=b[i];
    if(s.getFullYear()!=p){
        e.append($('<div class="row header year" style="width:'+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>'));
        p=s.getFullYear();
        f=0
        }
        f++;
    if(s.getMonth()!=q){
        g.append($('<div class="row header month" style="width:'+N.getCellSize()*h+'px;"><div class="label">'+L.months[q]+'</div></div>'));
        q=s.getMonth();
        h=0
        }
        h++;
    var w=s.getDay();
    var y=c[w];
    if(o.indexOf((new Date(s.getFullYear(),s.getMonth(),s.getDate())).getTime())>-1)y="holiday";
    j+='<div class="row day '+y+'" '+' id="dh-'+N.genId(s.getTime())+' "> '+' <div class="label"/>'+s.getDate()+'</div></div>';
    l+='<div class="row day '+y+'" '+' id="dw-'+N.genId(s.getTime())+'"> '+' <div class="label"/>'+L.dow[w]+'</div></div>'
    }
    e.append('<div class="row header year" style="width: '+N.getCellSize()*f+'px;"><div class="label">'+p+'</div></div>');
    g.append('<div class="row header month" style="width: '+N.getCellSize()*h+'px"><div class="label">'+L.months[q]+'</div></div>');
    var B=M.dataPanel(a,b.length*N.getCellSize());
    B.append(e);
    B.append(g);
    B.append($('<div class="row"/>').html(j));
    B.append($('<div class="row"/>').html(l));
    for(var i=0;i<a.data.length;i++){
    var C=a.data[i];
    if(i>=a.pageNum*L.itemsPerPage&&i<(a.pageNum*L.itemsPerPage+L.itemsPerPage)){
        var D='<div class="row highlight'+i+' noht">';
        for(var x=0;x<b.length;x++){
            r=b[x];
            var E=d[r.getDay()];
            if(o.indexOf((new Date(r.getFullYear(),r.getMonth(),r.getDate())).getTime())>-1)E=" holiday";
            D+='<div class="row day'+E+'" id="d'+i+'-'+N.genId(r.getTime())+'"></div>'
            };
            
        B.append($(D+'</div>'))
        }
    }
break
}
return $('<div class="rightPanel"></div>').append(B)
},
navigation:function(a){
    var b=null;
    if(L.navigate=='scroll'){
        b=$('<div class="navigate" />').append($('<div class="nav-slider" />').append($('<div class="nav-slider-left" />').append($('<a href="javascript:///" class="nav-link nav-page-back"/>').html('&lt;').click(function(){
            M.navigatePage(a,-1)
            })).append($('<div class="page-number"/>').append($('<span/>').html(a.pageNum+1+' of '+a.pageCount))).append($('<a href="javascript:///" class="nav-link nav-page-next"/>').html('&gt;').click(function(){
            M.navigatePage(a,1)
            })).append($('<a href="javascript:///" class="nav-link nav-now"/>').html('&#9679;').click(function(){
            M.navigateTo(a,'now')
            })).append($('<a href="javascript:///" class="nav-link nav-prev-day"/>').html('&lt;').click(function(){
            M.navigateTo(a,N.getCellSize())
            }))).append($('<div class="nav-slider-content" />').append($('<div class="nav-slider-bar" />').append($('<a class="nav-slider-button" />')).mousedown(function(e){
            if(e.preventDefault)e.preventDefault();
            a.scrollNavigation.scrollerMouseDown=true;
            M.sliderScroll(a,e)
            }).mousemove(function(e){
            if(a.scrollNavigation.scrollerMouseDown){
                M.sliderScroll(a,e)
                }
            }))).append($('<div class="nav-slider-right" />').append($('<a href="javascript:///" class="nav-link nav-next-day"/>').html('&gt;').click(function(){
            M.navigateTo(a,N.getCellSize()*-1)
            })).append($('<a href="javascript:///" class="nav-link nav-zoomIn"/>').html('&#43;').click(function(){
            M.zoomInOut(a,-1)
            })).append($('<a href="javascript:///" class="nav-link nav-zoomOut"/>').html('&#45;').click(function(){
            M.zoomInOut(a,1)
            }))));
    $(document).mouseup(function(){
        a.scrollNavigation.scrollerMouseDown=false
        })
    }else{
    b=$('<div class="navigate" />').append($('<a href="javascript:///" class="nav-link nav-page-back"/>').html('&lt;').click(function(){
        M.navigatePage(a,-1)
        })).append($('<div class="page-number"/>').append($('<span/>').html(a.pageNum+1+' of '+a.pageCount))).append($('<a href="javascript:///" class="nav-link nav-page-next"/>').html('&gt;').click(function(){
        M.navigatePage(a,1)
        })).append($('<a href="javascript:///" class="nav-link nav-begin"/>').html('&#124;&lt;').click(function(){
        M.navigateTo(a,'begin')
        })).append($('<a href="javascript:///" class="nav-link nav-prev-week"/>').html('&lt;&lt;').click(function(){
        M.navigateTo(a,N.getCellSize()*7)
        })).append($('<a href="javascript:///" class="nav-link nav-prev-day"/>').html('&lt;').click(function(){
        M.navigateTo(a,N.getCellSize())
        })).append($('<a href="javascript:///" class="nav-link nav-now"/>').html('&#9679;').click(function(){
        M.navigateTo(a,'now')
        })).append($('<a href="javascript:///" class="nav-link nav-next-day"/>').html('&gt;').click(function(){
        M.navigateTo(a,N.getCellSize()*-1)
        })).append($('<a href="javascript:///" class="nav-link nav-next-week"/>').html('&gt;&gt;').click(function(){
        M.navigateTo(a,N.getCellSize()*-7)
        })).append($('<a href="javascript:///" class="nav-link nav-end"/>').html('&gt;&#124;').click(function(){
        M.navigateTo(a,'end')
        })).append($('<a href="javascript:///" class="nav-link nav-zoomIn"/>').html('&#43;').click(function(){
        M.zoomInOut(a,-1)
        })).append($('<a href="javascript:///" class="nav-link nav-zoomOut"/>').html('&#45;').click(function(){
        M.zoomInOut(a,1)
        }))
    }
    return $('<div class="bottom"/>').append(b)
},
createProgressBar:function(b,c,d,f,g,ii){
    var h=N.getCellSize();
    var i=N.getProgressBarMargin()||0;
    var j=c?"id='"+c+"'":"";
    var k=$("<div "+j+" class='bar getTask"+ii+"'><div class='label'>"+g+"</div></div>").addClass(d).css({
        width:((h*b)-i)
        });
    if(f){
        k.mouseover(function(e){
            var a=$("<div class='fn-gantt-hint' />").html(f);
            $("body").append(a);
            a.css('left',e.pageX);
            a.css('top',e.pageY);
            a.show()
            }).mouseout(function(){
            $(".fn-gantt-hint").remove()
            }).mousemove(function(e){
            $('.fn-gantt-hint').css('left',e.pageX);
            $('.fn-gantt-hint').css('top',e.pageY+15)
            })
        }
        return k
    },
markNow:function(a){
    switch(L.scale){
        case'weeks':
            var b=Date.parse(new Date());
            b=(Math.floor(b/36400000)*36400000);
            $(a).find(':findweek("'+b+'")').removeClass('wd').addClass('today');
            break;
        case'months':
            $(a).find(':findmonth("'+new Date().getTime()+'")').removeClass('wd').addClass('today');
            break;
        default:
            var b=Date.parse(new Date());
            b=(Math.floor(b/36400000)*36400000);
            $(a).find(':findday("'+b+'")').removeClass('wd').addClass('today');
            break
            }
        },
fillData:function(F){
    var H=function(a){
        try{
            a=a.replace('rgb(','').replace(')','');
            var b=a.split(',');
            var R=parseInt(b[0]);
            var G=parseInt(b[1]);
            var B=parseInt(b[2]);
            var c=Math.round((255-(0.299*R+0.587*G+0.114*B))*0.9,1);
            return'rgb('+c+', '+c+', '+c+')'
            }catch(err){
            return''
            }
        };
    
var I=function(a){
    try{
        a=a.replace('rgb(','').replace(')','');
        var b=a.split(',');
        var R=parseInt(b[0]);
        var G=parseInt(b[1]);
        var B=parseInt(b[2]);
        R=R-Math.round(parseInt(R)/7);
        G=G-Math.round(parseInt(G)/7);
        B=B-Math.round(parseInt(B)/7);
        return'rgb('+R+', '+G+', '+B+')'
        }catch(err){
        return''
        }
    };

$.each(F.data,function(i,o){
    if(i>=F.pageNum*L.itemsPerPage&&i<(F.pageNum*L.itemsPerPage+L.itemsPerPage)){
        $.each(o.values,function(j,a){
            var b=null;
            switch(L.scale){
                case'hours':
                    var c=N.genId(N.dateDeserialize(a.from).getTime(),F.scaleStep);
                    var d=N.genId(N.dateDeserialize(a.to).getTime(),F.scaleStep);
                    var e=$(F).find('#d'+i+'-'+c).offset().left;
                    var f=$(F).find('#d'+i+'-'+d).offset().left;
                    var g=Math.floor((f-e)/N.getCellSize())+1;
                    b=M.createProgressBar(g,a.id?a.id:'',a.customClass?a.customClass:'',a.desc?a.desc:'',a.label?a.label:'',i);
                    $(F).find('#d'+i+'-'+N.genId(N.dateDeserialize(a.from).getTime(),F.scaleStep)).append(b);
                    break;
                case'weeks':case'months':
                    var h=N.dateDeserialize(a.from);
                    var k=N.dateDeserialize(a.to);
                    if(h.getDate()<=3&&h.getMonth()==0)h.setDate(h.getDate()+4);
                    if(k.getDate()<=3&&k.getMonth()==0)k.setDate(k.getDate()+4);
                    var c=N.genId(h.getTime());
                    var d=N.genId(k.getTime());
                    var e=$(F).find('#d'+i+'-'+c).offset().left;
                    var f=$(F).find('#d'+i+'-'+d).offset().left;
                    var g=Math.round((f-e)/N.getCellSize())+1;
                    b=M.createProgressBar(g,a.id?a.id:'',a.customClass?a.customClass:'',a.desc?a.desc:'',a.label?a.label:'',i);
                    $(F).find('#d'+i+'-'+N.genId(h.getTime(),F.scaleStep)).append(b);
                    break;
                default:
                    var c=N.genId(N.dateDeserialize(a.from).getTime());
                    var d=N.genId(N.dateDeserialize(a.to).getTime());
                    var g=Math.floor(((d/1000)-(c/1000))/86400)+1;
                    b=M.createProgressBar(g,a.id?a.id:'',a.customClass?a.customClass:'',a.desc?a.desc:'',a.label?a.label:'',i);
                    var l=$(F).find('#d'+i+'-'+N.genId(N.dateDeserialize(a.from).getTime()));
                    l.append(b);
                    break
                    }
                    var m=b.find('.label');
            if(m){
                var n=H(b.css("background-color"));
                m.css('color',n)
                }
            })
    }
});
$.each(F.data,function(i,E){
    $.each(E.values,function(j,f){
        if(f.id&&f.dep){
            var g=$("#"+f.id);
            var h=$("#"+f.dep);
            if(g.length>0&&h.length<=0){
                var k=$("<div id='"+f.id+"-"+f.dep+"Start' class='depStart'></div>");
                var l=$("<div id='"+f.id+"-"+f.dep+"End' class='depEnd'></div>");
                k.css('background-color',"#888");
                l.css('background-color',g.css("background-color"));
                var m=g.position();
                var n=g.parent().position();
                var o={
                    left:n.left+g.outerWidth()+3,
                    top:n.top+Math.round(g.outerHeight()/2)+2
                    };
                    
                k.css('left',o.left-5+"px");
                k.css('top',o.top-4+"px");
                l.css('left',o.left+16+"px");
                l.css('top',o.top-4+"px");
                var p=$("<div id='"+f.id+"-"+f.dep+"Top' class='depLine'></div>");
                p.css('left',o.left-5+"px");
                p.css('top',o.top+1+"px");
                p.css('width',"25px");
                p.css('height',"5px");
                p.css('border-top',"1px solid #333");
                var q=null;
                for(i=0;i<F.data.length;i++)for(j=0;j<F.data[i].values.length;j++)if(F.data[i].values[j].id==f.dep){
                    q=F.data[i].values[j];
                    break
                }
                var r="#FF0D00";
                var s=function(e){
                    k.css("border-color",r);
                    l.css("border-color",r);
                    k.css("z-index","10002");
                    l.css("z-index","10002");
                    p.css("z-index","10000");
                    p.css("border-color",r)
                    };
                    
                var t=function(e){
                    k.css("border-color","#fff");
                    l.css("border-color","#fff");
                    k.css("z-index","10001");
                    l.css("z-index","10001");
                    p.css("z-index","9999");
                    p.css("border-color","#333")
                    };
                    
                if(q){
                    l.mouseover(function(e){
                        var a=$("<div class='fn-gantt-hint' />").html(q.desc);
                        $("body").append(a);
                        a.css('left',e.pageX);
                        a.css('top',e.pageY);
                        a.show()
                        }).mouseout(function(){
                        $(".fn-gantt-hint").remove()
                        }).mousemove(function(e){
                        $('.fn-gantt-hint').css('left',e.pageX);
                        $('.fn-gantt-hint').css('top',e.pageY+15)
                        })
                    }
                    k.mouseover(s);
                k.mouseout(t);
                l.mouseover(s);
                l.mouseout(t);
                var u=$(F).find('.fn-gantt .rightPanel');
                var v=u.find('.dataPanel');
                v.append(p);
                var w=p.clone();
                w.addClass("depLineSh");
                v.append(w);
                v.append(k);
                v.append(l)
                }else if(g.length>0&&h.length>0){
                var k=$("<div id='"+f.id+"-"+f.dep+"Start' class='depStart'></div>");
                var l=$("<div id='"+f.id+"-"+f.dep+"End' class='depEnd'></div>");
                k.css('background-color',h.css("background-color"));
                l.css('background-color',g.css("background-color"));
                var p=$("<div id='"+f.id+"-"+f.dep+"Top' class='depLine'></div>");
                var x=$("<div id='"+f.id+"-"+f.dep+"Bottom' class='depLine'></div>");
                var m=g.position();
                var y=h.position();
                var n=g.parent().position();
                var z=h.parent().position();
                var o={
                    left:n.left+g.outerWidth()+3,
                    top:n.top+Math.round(g.outerHeight()/2)+2
                    };
                    
                var A={
                    left:y.left+1,
                    top:z.top+Math.round(h.outerHeight()/2)+2
                    };
                    
                k.css('left',o.left-5+"px");
                k.css('top',o.top-4+"px");
                l.css('left',A.left-2+"px");
                l.css('top',A.top-4+"px");
                var B=function(a,b,c,d){
                    a.css('left',b+"px");
                    a.css('width',c+"px");
                    var e="1px solid #333";
                    for(i=0;i<d.length;i++){
                        a.css('border-'+d[i],e)
                        }
                    };
                    
            if(o.top<A.top){
                var C=Math.round(Math.abs(o.left-A.left)/2);
                if(o.left<A.left){
                    B(p,o.left,C,["top","right"]);
                    B(x,o.left+C,C,["left","bottom"])
                    }else{
                    B(p,A.left+C,C+5,["right","bottom"]);
                    B(x,A.left,C+5,["top","left"])
                    }
                    p.css('top',o.top+1+"px");
                p.css('height',Math.floor((A.top-o.top)/2)+"px");
                x.css('top',o.top+Math.floor((A.top-o.top)/2)+1+"px");
                x.css('height',Math.floor((A.top-o.top)/2)+"px")
                }else{
                var C=Math.round(Math.abs(o.left-A.left)/2);
                if(o.left<A.left){
                    B(x,o.left,C,["bottom","right"]);
                    B(p,o.left+C,C,["left","top"])
                    }else{
                    B(x,A.left+C,C+5,["top","right"]);
                    B(p,A.left,C+5,["left","bottom"])
                    }
                    p.css('top',A.top+1+"px");
                p.css('height',Math.floor((o.top-A.top)/2)+"px");
                x.css('top',A.top+Math.floor((o.top-A.top)/2)+1+"px");
                x.css('height',Math.floor((o.top-A.top)/2)+"px")
                }
                var r="#FF0D00";
            var s=function(e){
                k.css("border-color",r);
                l.css("border-color",r);
                k.css("z-index","10002");
                l.css("z-index","10002");
                p.css("z-index","10000");
                x.css("z-index","10000");
                p.css("border-color",r);
                x.css("border-color",r)
                };
                
            var t=function(e){
                k.css("border-color","#fff");
                l.css("border-color","#fff");
                k.css("z-index","10001");
                l.css("z-index","10001");
                p.css("z-index","9999");
                x.css("z-index","9999");
                p.css("border-color","#333");
                x.css("border-color","#333")
                };
                
            k.mouseover(s);
            k.mouseout(t);
            l.mouseover(s);
            l.mouseout(t);
            var u=$(F).find('.fn-gantt .rightPanel');
            var v=u.find('.dataPanel');
            v.append(p);
            v.append(x);
            var w=p.clone();
            var D=x.clone();
            w.addClass("depLineSh");
            D.addClass("depLineSh");
            v.append(w);
            v.append(D);
            v.append(k);
            v.append(l)
            }
        }
    })
})
},
navigateTo:function(a,b){
    var c=$(a).find('.fn-gantt .rightPanel');
    var d=c.find('.dataPanel');
    var e=c.width();
    var f=d.width();
    switch(b){
        case'begin':
            d.animate({
            'margin-left':'0px'
        },'fast',function(){
            M.repositionLabel(a)
            });
        a.scrollNavigation.panelMargin=0;
        break;
        case'end':
            var g=f-e;
            a.scrollNavigation.panelMargin=g*-1;
            d.animate({
            'margin-left':'-'+g+'px'
            },'fast',function(){
            M.repositionLabel(a)
            });
        break;
        case'now':
            if(!a.scrollNavigation.canScroll)return false;
            var h=(f-e)*-1;
            var i=d.css('margin-left').replace('px','');
            var b=d.find('.today').offset().left-d.offset().left;
            b*=-1;
            if(b>0)b=0;
            else if(b<h)b=h;
            d.animate({
            'margin-left':b+'px'
            },'fast',M.repositionLabel(a));
            a.scrollNavigation.panelMargin=b;
            break;
        default:
            var h=(f-e)*-1;
            var i=d.css('margin-left').replace('px','');
            var b=parseInt(i)+b;
            if(b<=0&&b>=h)d.animate({
            'margin-left':b+'px'
            },'fast',M.repositionLabel(a));
            a.scrollNavigation.panelMargin=b;
            break
            }
        },
navigatePage:function(a,b){
    if((a.pageNum+b)>=0&&(a.pageNum+b)<Math.ceil(a.rowsNum/L.itemsPerPage)){
        M.waitToggle(a,true,function(){
            a.pageNum+=b;
            a.hPosition=$('.fn-gantt .dataPanel').css('margin-left').replace('px','');
            a.scaleOldWidth=false;
            M.init(a)
            })
        }
    },
zoomInOut:function(g,h){
    M.waitToggle(g,true,function(){
        var a=(h<0);
        var b=g.scaleStep+h*3;
        b=b<=1?1:b==4?3:b;
        var c=L.scale;
        var d=g.headerRows;
        if(L.scale=='hours'&&b>=13){
            c='days';
            d=4;
            b=13
            }else if(L.scale=='days'&&a){
            c='hours';
            d=5;
            b=12
            }else if(L.scale=='days'&&!a){
            c='weeks';
            d=3;
            b=13
            }else if(L.scale=='weeks'&&!a){
            c='months';
            d=2;
            b=14
            }else if(L.scale=='weeks'&&a){
            c='days';
            d=4;
            b=13
            }else if(L.scale=='months'&&a){
            c='weeks';
            d=3;
            b=13
            }
            if((a&&$.inArray(c,K)<$.inArray(L.minScale,K))||(!a&&$.inArray(c,K)>$.inArray(L.maxScale,K))){
            M.init(g);
            return
        }
        g.scaleStep=b;
        L.scale=c;
        g.headerRows=d;
        var e=$(g).find('.fn-gantt .rightPanel');
        var f=e.find('.dataPanel');
        g.hPosition=f.css('margin-left').replace('px','');
        g.scaleOldWidth=(f.width()-e.width());
        M.init(g)
        })
    },
mouseScroll:function(a,e){ //alert(e);
    var b=$(a).find('.fn-gantt .dataPanel');
    b.css("cursor","move");
    var c=b.offset();
    var d=a.scrollNavigation.mouseX==null?e.pageX:a.scrollNavigation.mouseX;
    var f=e.pageX-d;
    a.scrollNavigation.mouseX=e.pageX;
    M.scrollPanel(a,f);
    clearTimeout(a.scrollNavigation.repositionDelay);
    a.scrollNavigation.repositionDelay=setTimeout(M.repositionLabel,50,a)
    },
wheelScroll:function(a,e){
    var b=e.detail?e.detail*(-50):e.wheelDelta/120*50;
    M.scrollPanel(a,b);
    clearTimeout(a.scrollNavigation.repositionDelay);
    a.scrollNavigation.repositionDelay=setTimeout(M.repositionLabel,50,a);
    if(e.preventDefault)e.preventDefault();else return false
        },
sliderScroll:function(a,e){
    var b=$(a).find('.nav-slider-bar');
    var c=b.find('.nav-slider-button');
    var d=$(a).find('.fn-gantt .rightPanel');
    var f=d.find('.dataPanel');
    var g=b.offset();
    var h=b.width();
    var i=c.width();
    if((e.pageX>=g.left)&&(e.pageX<=g.left+h)){
        var j=e.pageX-g.left;
        var j=j-i/2;
        c.css('left',j);
        var k=f.width()-d.width();
        var l=j*k/h*-1;
        if(l>=0){
            f.css('margin-left','0px');
            a.scrollNavigation.panelMargin=0
            }else if(j>=h-(i*1)){
            f.css('margin-left',k*-1+'px');
            a.scrollNavigation.panelMargin=k*-1
            }else{
            f.css('margin-left',l+'px');
            a.scrollNavigation.panelMargin=l
            }
            clearTimeout(a.scrollNavigation.repositionDelay);
        a.scrollNavigation.repositionDelay=setTimeout(M.repositionLabel,50,a)
        }
    },
scrollPanel:function(a,b){
    if(!a.scrollNavigation.canScroll)return false;
    var c=parseInt(a.scrollNavigation.panelMargin)+b;
    if(c>0){
        a.scrollNavigation.panelMargin=0;
        $(a).find('.fn-gantt .dataPanel').css('margin-left',a.scrollNavigation.panelMargin+'px')
        }else if(c<a.scrollNavigation.panelMaxPos*-1){
        a.scrollNavigation.panelMargin=a.scrollNavigation.panelMaxPos*-1;
        $(a).find('.fn-gantt .dataPanel').css('margin-left',a.scrollNavigation.panelMargin+'px')
        }else{
        a.scrollNavigation.panelMargin=c;
        $(a).find('.fn-gantt .dataPanel').css('margin-left',a.scrollNavigation.panelMargin+'px')
        }
    },
synchronizeScroller:function(a){
    if(L.navigate=='scroll'){
        var b=$(a).find('.fn-gantt .rightPanel');
        var c=b.find('.dataPanel');
        var d=$(a).find('.nav-slider-bar');
        var e=d.find('.nav-slider-button');
        var f=d.width();
        var g=e.width();
        var h=c.width()-b.width();
        var i=0;
        if(c.css('margin-left'))i=c.css('margin-left').replace('px','');
        var j=i*f/h-e.width()*0.25;
        j=j>0?0:(j*-1>=f-(g*0.75))?(f-(g*1.25))*-1:j;
        e.css('left',j*-1)
        }
    },
repositionLabel:function(f){
    var g=$('.fn-gantt .rightPanel');
    var h=g.find('.dataPanel');
    h.stop();
    var j={
        offset:g.offset(),
        width:g.width(),
        height:g.height()
        };
        
    $(".fn-gantt .rightPanel .year, .fn-gantt .rightPanel .month").each(function(i,a){
        var b={
            offset:$(a).offset(),
            width:$(a).width(),
            height:$(a).height()
            };
            
        if(b.offset.left+b.width>j.offset.left&&b.offset.left<j.offset.left+j.width){
            var c={
                left:b.offset.left>j.offset.left?b.offset.left:j.offset.left,
                right:b.offset.left+b.width<j.offset.left+j.width?b.offset.left+b.width:j.offset.left+j.width
                };
                
            $(a).children(".label").css("float","left");
            var d=$(a).children(".label").width();
            var e=b.offset.left<j.offset.left?j.offset.left-b.offset.left:0;
            if(c.right-c.left>d)$(a).children(".label").css("margin-left",e+(c.right-c.left)/2-d/2+"px")
                }
            });
$(".fn-gantt .rightPanel .bar").each(function(i,a){
    var b={
        offset:$(a).offset(),
        width:$(a).width(),
        height:$(a).height()
        };
        
    if(b.offset.left+b.width>j.offset.left&&b.offset.left<j.offset.left+j.width){
        var c={
            left:b.offset.left>j.offset.left?b.offset.left:j.offset.left,
            right:b.offset.left+b.width<j.offset.left+j.width?b.offset.left+b.width:j.offset.left+j.width
            };
            
        $(a).children(".label").css("float","left");
        var d=$(a).children(".label").width();
        var e=b.offset.left<j.offset.left?j.offset.left-b.offset.left:0;
        if(c.right-c.left>d)$(a).children(".label").css("margin-left",e+(c.right-c.left)/2-d/2+"px")
            }
        });
M.synchronizeScroller(f)
},
waitToggle:function(a,b,c){
    if(b){
        var d=$(a).offset();
        var e=$(a).outerWidth();
        var f=$(a).outerHeight();
        if(!a.loader){
            a.loader=$('<div class="fn-gantt-loader" style="position: absolute; top: '+d.top+'px; left: '+d.left+'px; width: '+e+'px; height: '+f+'px;">'+'<div class="fn-gantt-loader-spinner"><span>'+L.waitText+'</span></div></div>')
            }
            $('body').append(a.loader);
        setTimeout(c,100)
        }else{
        if(a.loader)a.loader.remove();
        a.loader=null
        }
    }

};


var N={
    getMaxDate:function(c){
        var d=null;
        $.each(c.data,function(i,b){
            $.each(b.values,function(i,a){
                d=d<N.dateDeserialize(a.to)?N.dateDeserialize(a.to):d
                })
            });
        switch(L.scale){
            case'hours':
                d.setHours(Math.ceil((d.getHours())/c.scaleStep)*c.scaleStep);
                d.setHours(d.getHours()+c.scaleStep*3);
                break;
            case'weeks':
                var e=new Date(d.getTime());
                var e=new Date(e.setDate(e.getDate()+3*7));
                var f=Math.floor(e.getDate()/7)*7;
                d=new Date(e.getFullYear(),e.getMonth(),f==0?4:f-3);
                break;
            case'months':
                var e=new Date(d.getFullYear(),d.getMonth(),1);
                e.setMonth(e.getMonth()+2);
                d=new Date(e.getFullYear(),e.getMonth(),1);
                break;
            default:
                d.setHours(0);
                d.setDate(d.getDate()+3);
                break
                }
                return d
        },
    getMinDate:function(c){
        var d=null;
        $.each(c.data,function(i,b){
            $.each(b.values,function(i,a){
                d=d>N.dateDeserialize(a.from)||d==null?N.dateDeserialize(a.from):d
                })
            });
        switch(L.scale){
            case'hours':
                d.setHours(Math.floor((d.getHours())/c.scaleStep)*c.scaleStep);
                d.setHours(d.getHours()-c.scaleStep*3);
                break;
            case'weeks':
                var e=new Date(d.getTime());
                var e=new Date(e.setDate(e.getDate()-3*7));
                var f=Math.floor(e.getDate()/7)*7;
                d=new Date(e.getFullYear(),e.getMonth(),f==0?4:f-3);
                break;
            case'months':
                var e=new Date(d.getFullYear(),d.getMonth(),1);
                e.setMonth(e.getMonth()-3);
                d=new Date(e.getFullYear(),e.getMonth(),1);
                break;
            default:
                d.setHours(0);
                d.setDate(d.getDate()-3);
                break
                }
                return d
        },
    parseDateRange:function(a,b){
        var c=new Date(a.getTime());
        var d=new Date(b.getTime());
        var e=new Array();
        var i=0;
        do{
            e[i++]=new Date(c.getTime());
            c.setDate(c.getDate()+1)
            }while(c.getTime()<=b.getTime());
        return e
        },
    parseTimeRange:function(a,b,c){
        var d=new Date(a);
        var e=new Date(b);
        var f=new Array();
        var i=0;
        do{
            f[i]=new Date(d.getTime());
            d.setHours(d.getHours()+c);
            d.setHours(Math.floor((d.getHours())/c)*c);
            if(d.getDay()!=f[i].getDay())d.setHours(0);
            i++
        }while(d.getTime()<=b.getTime());
        return f
        },
    parseWeeksRange:function(a,b){
        var c=new Date(a);
        var d=new Date(b);
        var e=new Array();
        var i=0;
        do{
            if(c.getDay()==0){
                e[i++]=c.getDayForWeek()
                }
                c.setDate(c.getDate()+1)
            }while(c.getTime()<=b.getTime());
        return e
        },
    parseMonthsRange:function(a,b){
        var c=new Date(a);
        var d=new Date(b);
        var e=new Array();
        var i=0;
        do{
            e[i++]=new Date(c.getFullYear(),c.getMonth(),1);
            c.setMonth(c.getMonth()+1)
            }while(c.getTime()<=b.getTime());
        return e
        },
    dateDeserialize:function(a){
        var b=eval('new'+a.replace(/\//g,' '));
        return new Date(b.getUTCFullYear(),b.getUTCMonth(),b.getUTCDate(),b.getUTCHours(),b.getUTCMinutes())
        },
    genId:function(a){
        var t=new Date(a);
        switch(L.scale){
            case'hours':
                var b=t.getHours();
                if(arguments.length>=2)b=(Math.floor((t.getHours())/arguments[1])*arguments[1]);
                return(new Date(t.getFullYear(),t.getMonth(),t.getDate(),b)).getTime();
                break;
            case'weeks':
                return t.getFullYear()+'-'+t.getDayForWeek().getWeekOfYear();
                break;
            case'months':
                return t.getFullYear()+'-'+t.getMonth();
                break;
            default:
                return(new Date(t.getFullYear(),t.getMonth(),t.getDate())).getTime();
                break
                }
            },
_getCellSize:null,
getCellSize:function(){
    if(!N._getCellSize){
        $("body").append($("<div style='display: none; position: absolute;' class='fn-gantt' id='measureCellWidth'><div class='row'></div></div>"));
        N._getCellSize=$('#measureCellWidth .row').height();
        $('#measureCellWidth').empty().remove()
        }
        return N._getCellSize
    },
getRightPanelSize:function(){
    $("body").append($("<div style='display: none; position: absolute;' class='fn-gantt' id='measureCellWidth'><div class='rightPanel'></div></div>"));
    var a=$('#measureCellWidth .rightPanel').height();
    $('#measureCellWidth').empty().remove();
    return a
    },
getPageHeight:function(a){
    return a.pageNum+1==a.pageCount?a.rowsOnLastPage*N.getCellSize():L.itemsPerPage*N.getCellSize()
    },
_getProgressBarMargin:null,
getProgressBarMargin:function(){
    if(!N._getProgressBarMargin){
        $("body").append($("<div style='display: none; position: absolute;' id='measureBarWidth' ><div class='fn-gantt'><div class='rightPanel'><div class='dataPanel'><div class='row day'><div class='bar' /></div></div></div></div></div>"));
        N._getProgressBarMargin=parseInt($('#measureBarWidth .fn-gantt .rightPanel .day .bar').css("margin-left").replace("px",""));
        N._getProgressBarMargin+=parseInt($('#measureBarWidth .fn-gantt .rightPanel .day .bar').css("margin-right").replace("px",""));
        $('#measureBarWidth').empty().remove()
        }
        return N._getProgressBarMargin
    }

};

this.each(function(){
    if(J)$.extend(L,J);
    this.data=null;
    this.pageNum=0;
    this.pageCount=0;
    this.rowsOnLastPage=0;
    this.rowsNum=0;
    this.hPosition=0;
    this.dateStart=null;
    this.dateEnd=null;
    this.scrollClicked=false;
    this.scaleOldWidth=null;
    this.headerRows=null;
    switch(L.scale){
        case'hours':
            this.headerRows=5;
            this.scaleStep=1;
            break;
        case'weeks':
            this.headerRows=3;
            this.scaleStep=13;
            break;
        case'months':
            this.headerRows=2;
            this.scaleStep=14;
            break;
        default:
            this.headerRows=4;
            this.scaleStep=13;
            break
            }
            this.scrollNavigation={
        panelMouseDown:false,
        scrollerMouseDown:false,
        mouseX:null,
        panelMargin:0,
        repositionDelay:0,
        panelMaxPos:0,
        canScroll:true
    };
    
    this.gantt=null;
    this.loader=null;
    M.create(this)
    });
    
}
})(jQuery);

function highligh(id){
    if($(".highlight"+id).css('background-color') == 'rgb(253, 249, 144)'){
        $(".name").css('background-color','#F6F6F6');
        $(".noht").css('background-color','white');
        $(".dataPanel").css('margin-left','0px');
    }else{
        $(".name").css('background-color','#F6F6F6');
        $(".noht").css('background-color','white');
        $(".highlight"+id).css('background-color','#FDF990');
        //alert($(".highlight"+id).css('background-color'));
        $(".dataPanel").css('margin-left','0px');
        var cur_pos = $(".getTask"+id+"").offset().left;
        cur_pos = cur_pos - 400;
        $(".dataPanel").css('margin-left','-'+cur_pos+'px');
    }
}


//alert($(".getTask"+id+"").offset().left);
    
//cur_pos = cur_pos * -1;
    
//alert($(".getTask"+id+"").parent().attr('id'));
//var i = 0;//cur_pos;
//slide_left(-10,cur_pos);
//cur_pos = '-'+cur_pos+'px';
//  while(i>cur_pos){
//      setTimeout(function () { $(".dataPanel").css('margin-left',i+'px').delay(10);  }, 10);
//       i--;
//   }
    

//function slide_left(i,cur_pos){
//    setTimeout(function () {
//        i-=10;
//        $(".dataPanel").css('margin-left',i+'px');
//        if(i>cur_pos){
//          slide_left(i,cur_pos);  
//        }
//    },1);
//}