<?php
# MantisBT - a php based bugtracking system
# Copyright (C) 2002 - 2011  MantisBT Team - mantisbt-dev@lists.sourceforge.net
# MantisBT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# MantisBT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.

form_security_validate( 'plugin_googlelogin_config_update' );

auth_reauthenticate( );
access_ensure_global_level( config_get( 'manage_plugin_threshold' ) );



$f_api = (string)  gpc_get_string( 'api', 'XXXX' );
$f_client_id = (string)  gpc_get_string( 'client_id', 'XXXX' );
$f_client_secret = (string)  gpc_get_string( 'client_secret', 'XXXX' );
$f_redirect_url= (string)  gpc_get_string( 'url_redirect');
$f_domain_name= (string)  gpc_get_string( 'domain_name');
if(gpc_isset('disable_password'))
{
$f_disable_password= gpc_get_string('disable_password');
}
else{
    $f_disable_password=0;
}



if ( plugin_config_get( 'api' ) != $f_api ) {
	plugin_config_set( 'api', $f_api );
}
if ( plugin_config_get( 'client_id' ) != $f_client_id ) {
	plugin_config_set( 'client_id', $f_client_id);
}
if ( plugin_config_get( 'client_secret' ) != $f_client_secret ) {
	plugin_config_set( 'client_secret', (string)$f_client_secret );
}
if ( plugin_config_get( 'url_redirect') != $f_redirect_url) {
	plugin_config_set( 'url_redirect', $f_redirect_url);
}
if ( plugin_config_get( 'disable_password') != $f_disable_password) {
	plugin_config_set( 'disable_password', $f_disable_password);
}
if ( plugin_config_get( 'domain_name') != $f_domain_name) {
	plugin_config_set( 'domain_name', $f_domain_name);
}






if ( current_user_is_administrator() ) {
	$f_jpgraph_path = gpc_get_string( 'jpgraph_path', '' );
	if ( plugin_config_get( 'jpgraph_path' ) != $f_jpgraph_path ) {
		plugin_config_set( 'jpgraph_path', $f_jpgraph_path );
	}
}



form_security_purge( 'plugin_googlelogin_config_update' );

print_successful_redirect( plugin_page( 'config', true ) );
