<?php

require_once 'includes/google-api-php-client/apiClient.php';
require_once 'includes/google-api-php-client/contrib/apiOauth2Service.php';
require_once 'includes/idiorm.php';
require_once 'includes/relativeTime.php';

// Create a new Google API client
$client = new apiClient();
// Configure it
$redirect_url=config_get('plugin_GoogleLogin_url_redirect');
$client->setClientId(config_get('plugin_GoogleLogin_client_id'));
$client->setClientSecret(config_get('plugin_GoogleLogin_client_secret'));
$client->setDeveloperKey(config_get('plugin_GoogleLogin_api'));
$client->setRedirectUri($redirect_url);
$client->setApprovalPrompt(false);
$oauth2 = new apiOauth2Service($client);
$domain_name=config_get('plugin_GoogleLogin_domain_name');
$domain_list=explode(',',$domain_name);

if(count($domain_list)==1){
    $domain_string='&hd='.$domain_name;
}
else{
    $domain_trimmed=array();
    foreach($domain_list as $domain)
    {
    $domain_trimmed[]=trim($domain);
    }
    $domain_string='';
}
$googleUrl=($client->createAuthUrl().$domain_string);//
//var_dump($googleUrl);die;
// The code parameter signifies that this is
// a redirect from google, bearing a temporary code
if (isset($_GET['code'])) {    
	
	// This method will obtain the actuall access token from Google,
	// so we can request user info

	$client->authenticate();        
	$info = $oauth2->userinfo->get();
        $get_user_exp=explode('@', $info['email']);        
        $count=count($get_user_exp);
        $get_user_domain=$get_user_exp[$count-1];
        if(in_array($get_user_domain, $domain_trimmed))
        {
        $get_username=array();
        for($i=0;$i<$count-1;$i++){
            $get_username[]=$get_user_exp[$i];
        }
        $get_username=implode('@',$get_username);
        
        
        if(user_is_name_unique($get_username))
        {
            user_create( $get_username, 'afrojack_123_lkjzqirhg57869_@#',$info['email'],null,false,true,$info['name']);
            email_notify_new_account( $info['email'], $info['email'] );
        }
        
        $f_secure_session = gpc_get_bool( 'secure_session', false );
        $f_username = auth_prepare_username($get_username);
	$f_password = auth_prepare_password('afrojack_123_lkjzqirhg57869_@#');
        $t_return		= string_url( string_sanitize_url( gpc_get_string( 'return', config_get( 'default_home_page' ) ) ) );
	gpc_set_cookie( config_get_global( 'cookie_prefix' ) . '_secure_session', $f_secure_session ? '1' : '0' );

	if ( auth_attempt_login( $f_username, $f_password, $f_perm_login ) ) {
            
		session_set( 'secure_session', $f_secure_session );

		$t_redirect_url = 'login_cookie_test.php?return=' . $t_return;
                echo'<script>window.opener.location.href ="'.$t_redirect_url.'"; window.close();</script>';
	}
        elseif(!user_is_name_unique($get_username) ){
            $t_user_id = user_get_id_by_name( $get_username );
            if(user_is_enabled( $t_user_id )){
                auth_set_cookies( $t_user_id, false );
                auth_set_tokens( $t_user_id );
                session_set( 'secure_session', $f_secure_session );
		$t_redirect_url = 'login_cookie_test.php?return=' . $t_return;
                echo'<script>window.opener.location.href ="'.$t_redirect_url.'"; window.close();</script>';
            }
            else
            {
                $t_redirect_url = 'login_page.php?return=' . $t_return .
			'&error=1&username=' . urlencode( $f_username ) .
			'&perm_login=' . ( $f_perm_login ? 1 : 0 ) .
			'&secure_session=' . ( $f_secure_session ? 1 : 0 );
                echo'<script>window.opener.location.href ="'.$t_redirect_url.'"; window.close();</script>';
            }
            
        }
        else {            
		$t_redirect_url = 'login_page.php?return=' . $t_return .
			'&error=1&username=' . urlencode( $f_username ) .
			'&perm_login=' . ( $f_perm_login ? 1 : 0 ) .
			'&secure_session=' . ( $f_secure_session ? 1 : 0 );

		if ( HTTP_AUTH == config_get( 'login_method' ) ) {
			auth_http_prompt();
			exit;
		}
	}        
        echo'<script>window.opener.location.href ="'.$t_redirect_url.'"; window.close();</script>';
}
else{
    $f_secure_session = gpc_get_bool( 'secure_session', false );
        $f_username = auth_prepare_username($get_username);	
        $t_return		= string_url( string_sanitize_url( gpc_get_string( 'return', config_get( 'default_home_page' ) ) ) );
    $t_redirect_url = 'login_page.php?return=' . $t_return .
			'&error=1&username=' . urlencode( $f_username ) .
			'&perm_login=' . ( $f_perm_login ? 1 : 0 ) .
			'&secure_session=' . ( $f_secure_session ? 1 : 0 );
    echo'<script>window.opener.location.href ="'.$t_redirect_url.'"; window.close();</script>';
}
        
}
?>