<?php
# MantisBT - a php based bugtracking system

# MantisBT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# MantisBT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.

	/**
	 * @package MantisBT
	 * @copyright Copyright (C) 2000 - 2002  Kenzaburo Ito - kenito@300baud.org
	 * @copyright Copyright (C) 2002 - 2011  MantisBT Team - mantisbt-dev@lists.sourceforge.net
	 * @link http://www.mantisbt.org
	 */
	 /**
	  * MantisBT Core API's
	  */
	require_once( 'core.php' );

	require_once( 'compress_api.php' );
	require_once( 'filter_api.php' );
	require_once( 'current_user_api.php' );
	require_once( 'bug_api.php' );
	require_once( 'string_api.php' );
	require_once( 'date_api.php' );
	require_once( 'rss_api.php' );

	auth_ensure_user_authenticated();
        
        if(gpc_isset('update_position')){
            if(!gpc_isset('filter_ids'))
                $_SESSION['error_msg'] = 1;
            else{
                $filter_ids = gpc_get('filter_ids');
                $positioning = array();
                foreach ($filter_ids as $id) {
                    if (gpc_isset('filter_' . $id))
                        $positioning[] = array('filter_id' => $id, 'position' => gpc_get('filter_' . $id) , 'count' => gpc_get('filter_count_' . $id));
                }
                
                set_customize_filter_positioning('', 'update', $positioning);
                $_SESSION['success_msg'] = 1;
            }
        }
        
	$t_query_arr = filter_db_get_available_queries(null, null, $set_customize_filter=true);

	# Special case: if we've deleted our last query, we have nothing to show here.
	if ( count( $t_query_arr ) < 1 ) {
		print_header_redirect( 'customize_my_view_page_filter.php' );
	}

	compress_enable();

	html_page_top();

	$t_rss_enabled = config_get( 'rss_enabled' );
        
        
?>
<br/>
    
<div align="center">
<table class="width75" cellspacing="0">
<?php
	$t_column_count = 0;
	$t_max_column_count = 2;
        $pos_count = 0;
        $select_option = array();
	foreach( $t_query_arr as $t_id => $t_name ) {
		if ( $t_column_count == 0 ) {
			print '<tr ' . helper_alternate_class() . '>';
		}

		print '<td>';

		if ( OFF != $t_rss_enabled ) {
			# Use the "new" RSS link style.
			print_rss( rss_get_issues_feed_url( null, null, $t_id ), lang_get( 'rss' ) );
			echo ' ';
		}

		$t_query_id = db_prepare_int( $t_id );
		print_link( "view_all_set_customize_filter.php?type=3&source_query_id=$t_query_id", $t_name );

		if ( filter_db_can_delete_filter( $t_id ) ) {
			echo ' ';
			print_button( "query_delete_page_customize_filter.php?source_query_id=$t_query_id", lang_get( 'delete_query' ) );
		}
                $info = filter_db_get_customize_filter_info($t_id);
                $positon_numbr = $info['positioning'];
                echo '&nbsp&nbsp'.'Position : '.$positon_numbr;
                $pos_count++;
                $select_option[$t_id] = $positon_numbr;
                $select_bug_view_count[$t_id] = $info['bug_view_count'];
		print '</td>';

		$t_column_count++;
		if ( $t_column_count == $t_max_column_count ) {
			print '</tr>';
			$t_column_count = 0;
		}
	}

	# Tidy up this row
	if ( ( $t_column_count > 0 ) && ( $t_column_count < $t_max_column_count ) ) {
		for ( $i = $t_column_count; $i < $t_max_column_count; $i++ ) {
			print '<td>&#160;</td>';
		}
		print '</tr>';
	}
?>
</table>
</div>
<?php if($pos_count >1) {?>
<script type="text/javascript" src="js/jquery-1.7.1.min.js"></script>
<h4 style="margin: 5px 0px 2px 120px;padding:0px;"> Edit Position <?php print_succ_err_msg(); ?></h4>
    
<div style="border:1px solid #DEDEDE;width: 525px;margin-left: 120px;">
    <form action="" name="update_position" method="post">
        <div style="float:left;width:325px;text-align:right;padding:10px;">Filter Name :</div>
        <div style="float:left;text-align:left;padding:10px;">Position </div>
        <div style="float:left;text-align:left;padding:10px;">Count</div>
        <div style="clear:both;border-top: 1px solid #DEDEDE;"></div>
        <?php 
            $count_array = array('0','5','10','15','20','25');
            foreach( $t_query_arr as $t_id => $t_name ) {
                echo '<div style="float:left;width:325px;text-align:right;padding:10px;">'.$t_name.' :</div>';
                echo '<div style="float:left;text-align:left;padding:10px;">';
                    echo '<select name="filter_'.$t_id.'" class="pos_option" id="option'.$t_id.'">';
                        for($i=1;$i<=$pos_count;$i++){
                            if($i == $select_option[$t_id]){
                                $chk = ' selected="selected" ';
                                echo '<option value="'.$select_option[$t_id].'" '.$chk.'>'.$i.'</option>'; 
                                continue;
                            }
                            echo '<option value="'.$i.'">'.$i.'</option>';
                        }
                    echo '</select>';
                echo '</div>';
                echo '<div style="float:left;text-align:left;padding:10px 10px 10px 25px;">';
                    echo '<select name="filter_count_'.$t_id.'">';
                        foreach($count_array as $count_num){
                            if($count_num == $select_bug_view_count[$t_id]){
                                $chk = ' selected="selected" ';
                                if($count_num == '0'){
                                    echo '<option value="0" '.$chk.'>All</option>';continue; 
                                }
                                echo '<option value="'.$count_num.'" '.$chk.'>'.$count_num.'</option>'; 
                                continue;
                            }
                            if($count_num == '0'){
                                    echo '<option value="0" '.$chk.'>All</option>';continue; 
                            }
                            echo '<option value="'.$count_num.'">'.$count_num.'</option>';
                        }
                    echo '</select>';
                echo '</div>';
                
                echo '<div style="clear:both;border-top: 1px solid #DEDEDE;"></div>';
                echo '<input type="hidden" name="filter_ids[]" value="'.$t_id.'">';
            }
        ?>
        <input type="submit" name="update_position" value="Update Position">
    </form>
</div>

<script>
    $(document).ready(function() {
        var prevValue;
        $('.pos_option').focusin(function() {
            prevValue = $(this).val();
        }).change(function() {
            var selValue = $(this).val(), self = this;
            // set prev val to the select that has the current select val
            $('.pos_option').each(function() {
                if(this != self && $(this).val() == selValue) {
                    $(this).val(prevValue);
                    return false;
                }
            })
            $(this).blur();
        })
    })
</script>
<?php } ?>
<?php   
	html_page_bottom();
