<?php

// page to download timesheet data in excel report. Tahir Khan on 2august2012.
# MantisBT - a php based bugtracking system
# MantisBT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# MantisBT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with MantisBT.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This include file prints out the bug information
 * $f_bug_id MUST be specified before the file is included
 *
 * @package MantisBT
 * @copyright Copyright (C) 2000 - 2002  Kenzaburo Ito - kenito@300baud.org
 * @copyright Copyright (C) 2002 - 2011  MantisBT Team - mantisbt-dev@lists.sourceforge.net
 * @link http://www.mantisbt.org
 */
/**
 * MantisBT Core API's
 */
require_once( 'core.php' ); 
if(gpc_isset('draw_chart')){
    //echo '<pre>';print_r(get_bug_ids_for_gantt_chart(gpc_get('gantt_project_ids')));echo '</pre>';exit;
}

if (!auth_is_user_authenticated()) {
    access_denied();
}
html_page_top();
//echo '<pre>';print_r(bug_get(24));echo '</pre>';exit;
global $g_cache_project;
$t_project_ids = array();
$t_project_ids = $g_cache_project;
$project = array();
foreach($t_project_ids as $prjct){
    if(!$prjct['enabled'])continue;
    $project[$prjct['name']] = $prjct['id'];
}
$accesible_prjct = user_get_all_accessible_projects( auth_get_current_user_id(), ALL_PROJECTS );
foreach ($project as $name => $id) {
    if(!in_array($id,$accesible_prjct)) unset($project[$name]);
}
ksort($project);
//echo $t_resolved = config_get( 'bug_resolved_status_threshold' );
//$t_enum_values = MantisEnum::getAssocArrayIndexedByValues( 'status_enum_string' );
//echo '<pre>';print_r($t_enum_values);echo '</pre>';exit;
$status = array("feedback" => '20', "open" => '50', "resolved" => '80', "closed" => '90');


echo '<div class="taskBox_gantt">';
    echo '<form method="post" name="form_set_project_gantt" action="">';
        # CSRF protection not required here - form does not result in modifications
        echo '<div class="project_gantt">';
            echo '<label title="" for="">
                Projects 
            </label>';
            echo '<div class="wrapper">';
            if(!gpc_isset('gantt_project_ids')){
                echo '<select name="gantt_project_ids[]" style="width:120px" multiple="multiple">';
                    echo '<option value="0" selected="selected">All Projects</option>';
                    foreach ($project as $name => $id) {
                        echo '<option value="'.$id.'">';
                        echo $name;
                        echo '</option>';
                    }
                echo '</select> ';
            }else{
                $selected = gpc_get('gantt_project_ids');
                
                echo '<select name="gantt_project_ids[]" style="width:120px" multiple="multiple">';
                if(in_array('0',$selected))$chk='selected="selected"';
                    echo '<option value="0" '.$chk.'>All Projects</option>';
                    $chk = '';
                    foreach ($project as $name => $id) {
                        if(in_array($id,$selected))$chk='selected="selected"';
                        echo '<option value="'.$id.'" '.$chk.'>';
                        echo $name;
                        echo '</option>';
                        $chk = '';
                    }
                echo '</select> ';
            }
            echo '</div>';
        echo '</div>';

        echo '<div class="project_gantt">';
            echo '<label title="" for="">
                Status 
            </label>';
            echo '<div class="wrapper gantt_status">';
            if(!gpc_isset('status')){
                foreach($status as $name => $key){
                    $chk = '';
                    if($name == 'feedback' || $name == 'open')$chk='checked="checked"';
                    echo '<input '.$chk.' type="checkbox" name="status[]" value="'.$key.'" />&nbsp;'.$name.'<br/>';
                    $chk = '';
                }
            }else{
                $selected = gpc_get('status');
                foreach($status as $name => $key){
                    $chk = '';
                    if(in_array($key,$selected))$chk='checked="checked"';
                    echo '<input '.$chk.' type="checkbox" name="status[]" value="'.$key.'" />&nbsp;'.$name.'<br/>';
                    $chk = '';
                }
            }
            echo '</div>';
        echo '</div>';
        echo '<div class="project_gantt button_gantt">';
            echo '<input type="submit" name="draw_chart" class="button-small" value="Cleck To Draw" />';
        echo '</div>';
    echo '</form>';
echo '</div>';

?>
<script type="text/javascript" src="js/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="js/jquery.fn.gantt.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="css/style_gantt.css" type="text/css" media="screen" />
<?php
$bug_data = array();
if(!gpc_isset('draw_chart'))
    $bug_ids = get_bug_ids_for_gantt_chart(array_values($project));
else
   $bug_ids = get_bug_ids_for_gantt_chart(gpc_get('gantt_project_ids',''),gpc_get('status',''));

foreach($bug_ids as $id){
    $bug_data[] = bug_get($id);
}


if(!gpc_isset('draw_chart'))
    $sort_prjt_array = array_values($project);
else{
    $sort_prjt_array = gpc_get('gantt_project_ids','0');
    if($sort_prjt_array[0] == '0')
      $sort_prjt_array = array_values($project);  
}
    


$bug_data_sorted_project_wise = array();
$i=0;

foreach($sort_prjt_array as $key => $p_id){
    $project_name = project_get_field($p_id,'name');
    foreach($bug_data as $key2 => $bug_obj){
        if($bug_obj->project_id == $p_id){
            $from = custom_field_get_value(4,$bug_obj->id);
            $to = custom_field_get_value(1,$bug_obj->id);
            if($from == '' || $from == '0' || $to == '' || $to == '0' || $to < $from){
                unset($bug_data[$key2]);
                continue;
            }
            $bug_data_sorted_project_wise[$project_name][$i]['id']= $bug_obj->id;
            $summary = str_replace("'", "", $bug_obj->summary);
            $summary = str_replace('"', "", $summary);
            $bug_data_sorted_project_wise[$project_name][$i]['task_name'] = $summary;
            $bug_data_sorted_project_wise[$project_name][$i]['from'] = $from.'000';
            $bug_data_sorted_project_wise[$project_name][$i]['to'] =   $to.'000';
            unset($bug_data[$key2]);$i++;
        }
    }$i=0;
}

 
?>
<br/>
<?php   $str = '';
            foreach($bug_data_sorted_project_wise as $project_name => $data){
                $str .='{ "name": "'.$project_name.'","desc":"project","values": [{"":"","from": "/Date()/","to": "/Date()/","":"","":"","customClass":"clear_color","":""}]},'."\n";
                foreach($data as $value){//if($value['from'] < 1 || $value['to'] < 1)continue;
                   $str .='{ "name": "'.$value['task_name'].'","":"","values": [{"id":"'.$value['id'].'","from": "/Date('.$value['from'].')/","to": "/Date('.$value['to'].')/","desc":"Id: '.$value['id'].'<br/>Name: '.$value['task_name'].'<br/>Start Date: '.date('d M,Y',$value['from']/1000).'<br/>End Date:&nbsp;&nbsp; '.date('d M,Y',$value['to']/1000).'","label":"","customClass":"ganttGreen","":""}]},'."\n"; 
                }

            }
            //$str.='{ "name": "test","":"","values": [{"id":"b","from": "/Date()/","to": "/Date()/","":"","":"","customClass":"clear_color","":""}]}'; 
            ?>
<?php //echo $str;exit;?>


<script type="text/javascript">
    <!--
    jQuery(function () {
  
        var data = [
//            { "name": "CMS","":"","values": [{"":"","from": "/Date()/","to": "/Date()/","":"","":"","customClass":"clear_color","":""}]},
//            { "name": "tstt","":"","values": [{"id":"664","from": "/Date(1342981800000)/","to": "/Date(1343068200000)/","desc":"Id: 664 Name: ","label":"","customClass":"ganttGreen","":""}]},
//            { "name": "Theme for CMS system (wordpress)","":"","values": [{"id":"394","from": "/Date(1335465000000)/","to": "/Date(1335205800000)/","desc":"Id: 394 Name: ","label":"","customClass":"ganttGreen","":""}]},
//            { "name": "Move Campusbit website to Rackspace","":"","values": [{"id":"290","from": "/Date(1335465000000000)/","to": "/Date(1336626600000)/","desc":"Id: 290 Name: ","label":"","customClass":"ganttGreen","":""}]},
//            { "name": "CMS Performance Management - Send Queries, Upload files","":"","values": [{"id":"93","from": "/Date(1325874600000)/","to": "/Date(1325874600000)/","desc":"Id: 93 Name: ","label":"","customClass":"ganttGreen","":""}]}
//                
            <?php echo $str; ?>
            ];

        $(".gantt").gantt({source: data,itemsPerPage: 50, navigate: 'scroll', scale: 'days', maxScale: 'weeks', minScale: 'hours'});

    });
    -->
</script>

<div class="gantt_chart">
    <div class="gantt" style="width: 930px;"></div>
</div>


<?php

html_page_bottom();
?>